/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.ImportConflictResolutionMode;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ImportS3TargetSpectraS3Request
extends AbstractRequest {
    private final String s3Target;
    private final String cloudBucketName;
    private ImportConflictResolutionMode conflictResolutionMode;
    private String dataPolicyId;
    private Priority priority;
    private String userId;

    public ImportS3TargetSpectraS3Request(String cloudBucketName, String s3Target) {
        this.s3Target = s3Target;
        this.cloudBucketName = cloudBucketName;
        this.getQueryParams().put("operation", "import");
        this.updateQueryParam("cloud_bucket_name", cloudBucketName);
    }

    public ImportS3TargetSpectraS3Request withConflictResolutionMode(ImportConflictResolutionMode conflictResolutionMode) {
        this.conflictResolutionMode = conflictResolutionMode;
        this.updateQueryParam("conflict_resolution_mode", conflictResolutionMode);
        return this;
    }

    public ImportS3TargetSpectraS3Request withDataPolicyId(UUID dataPolicyId) {
        this.dataPolicyId = dataPolicyId.toString();
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportS3TargetSpectraS3Request withDataPolicyId(String dataPolicyId) {
        this.dataPolicyId = dataPolicyId;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportS3TargetSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public ImportS3TargetSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ImportS3TargetSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/s3_target/" + this.s3Target;
    }

    public String getS3Target() {
        return this.s3Target;
    }

    public String getCloudBucketName() {
        return this.cloudBucketName;
    }

    public ImportConflictResolutionMode getConflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getUserId() {
        return this.userId;
    }
}

