/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.ImportConflictResolutionMode;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ImportPoolSpectraS3Request
extends AbstractRequest {
    private final String pool;
    private ImportConflictResolutionMode conflictResolutionMode;
    private String dataPolicyId;
    private Priority priority;
    private String storageDomainId;
    private String userId;
    private Priority verifyDataAfterImport;
    private boolean verifyDataPriorToImport;

    public ImportPoolSpectraS3Request(String pool) {
        this.pool = pool;
        this.getQueryParams().put("operation", "import");
    }

    public ImportPoolSpectraS3Request withConflictResolutionMode(ImportConflictResolutionMode conflictResolutionMode) {
        this.conflictResolutionMode = conflictResolutionMode;
        this.updateQueryParam("conflict_resolution_mode", conflictResolutionMode);
        return this;
    }

    public ImportPoolSpectraS3Request withDataPolicyId(UUID dataPolicyId) {
        this.dataPolicyId = dataPolicyId.toString();
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportPoolSpectraS3Request withDataPolicyId(String dataPolicyId) {
        this.dataPolicyId = dataPolicyId;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportPoolSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public ImportPoolSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public ImportPoolSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public ImportPoolSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ImportPoolSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ImportPoolSpectraS3Request withVerifyDataAfterImport(Priority verifyDataAfterImport) {
        this.verifyDataAfterImport = verifyDataAfterImport;
        this.updateQueryParam("verify_data_after_import", verifyDataAfterImport);
        return this;
    }

    public ImportPoolSpectraS3Request withVerifyDataPriorToImport(boolean verifyDataPriorToImport) {
        this.verifyDataPriorToImport = verifyDataPriorToImport;
        this.updateQueryParam("verify_data_prior_to_import", verifyDataPriorToImport);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/pool/" + this.pool;
    }

    public String getPool() {
        return this.pool;
    }

    public ImportConflictResolutionMode getConflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Priority getVerifyDataAfterImport() {
        return this.verifyDataAfterImport;
    }

    public boolean getVerifyDataPriorToImport() {
        return this.verifyDataPriorToImport;
    }
}

