/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.S3ObjectType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetObjectsWithFullDetailsSpectraS3Request
extends AbstractPaginationRequest {
    private String bucketId;
    private boolean includePhysicalPlacement;
    private boolean lastPage;
    private boolean latest;
    private String name;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private S3ObjectType type;
    private long version;

    public GetObjectsWithFullDetailsSpectraS3Request() {
        this.getQueryParams().put("full_details", null);
    }

    public GetObjectsWithFullDetailsSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withIncludePhysicalPlacement(boolean includePhysicalPlacement) {
        this.includePhysicalPlacement = includePhysicalPlacement;
        if (this.includePhysicalPlacement) {
            this.getQueryParams().put("include_physical_placement", null);
        } else {
            this.getQueryParams().remove("include_physical_placement");
        }
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withLatest(boolean latest) {
        this.latest = latest;
        this.updateQueryParam("latest", latest);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withType(S3ObjectType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    public GetObjectsWithFullDetailsSpectraS3Request withVersion(long version) {
        this.version = version;
        this.updateQueryParam("version", version);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/object";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public boolean getIncludePhysicalPlacement() {
        return this.includePhysicalPlacement;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public boolean getLatest() {
        return this.latest;
    }

    public String getName() {
        return this.name;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public S3ObjectType getType() {
        return this.type;
    }

    public long getVersion() {
        return this.version;
    }
}

