/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.HeadObjectResponse;
import com.spectralogic.ds3client.commands.interfaces.MetadataImpl;
import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.networking.Metadata;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;

public class HeadObjectResponseParser
extends AbstractResponseParser<HeadObjectResponse> {
    private final int[] expectedStatusCodes = new int[]{200, 404};

    @Override
    public HeadObjectResponse parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            MetadataImpl metadata = new MetadataImpl(response.getHeaders());
            long objectSize = ResponseParserUtils.getSizeFromHeaders(response.getHeaders());
            switch (statusCode) {
                case 200: {
                    return new HeadObjectResponse((Metadata)metadata, objectSize, HeadObjectResponse.Status.EXISTS, this.getChecksum(), this.getChecksumType());
                }
                case 404: {
                    return new HeadObjectResponse((Metadata)metadata, objectSize, HeadObjectResponse.Status.DOESNTEXIST, this.getChecksum(), this.getChecksumType());
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

