/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetBlobsOnTapeSpectraS3Response;
import com.spectralogic.ds3client.models.BulkObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetBlobsOnTapeSpectraS3ResponseParser
extends AbstractResponseParser<GetBlobsOnTapeSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetBlobsOnTapeSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        BulkObjectList result = XmlOutput.fromXml(inputStream, BulkObjectList.class);
                        GetBlobsOnTapeSpectraS3Response getBlobsOnTapeSpectraS3Response = new GetBlobsOnTapeSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getBlobsOnTapeSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

