/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.http.entity.ContentType;

public class GetObjectRequest
extends AbstractRequest {
    private final WritableByteChannel channel;
    private final String bucketName;
    private final String objectName;
    private String job;
    private long offset;
    private ImmutableCollection<Range> byteRanges = null;
    private ChecksumType checksum = ChecksumType.none();
    private ChecksumType.Type checksumType = ChecksumType.Type.NONE;

    @Deprecated
    public GetObjectRequest(String bucketName, String objectName, @Nonnull WritableByteChannel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.channel = channel;
    }

    public GetObjectRequest(String bucketName, String objectName, @Nonnull WritableByteChannel channel, UUID job, long offset) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.job = job.toString();
        this.offset = offset;
        this.channel = channel;
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public GetObjectRequest(String bucketName, String objectName, @Nonnull WritableByteChannel channel, String job, long offset) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.job = job;
        this.offset = offset;
        this.channel = channel;
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public GetObjectRequest(String bucketName, String objectName, UUID job, long offset, @Nonnull OutputStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.job = job.toString();
        this.offset = offset;
        this.channel = Channels.newChannel(stream);
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public GetObjectRequest(String bucketName, String objectName, String job, long offset, @Nonnull OutputStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream may not be null.");
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.job = job;
        this.offset = offset;
        this.channel = Channels.newChannel(stream);
        this.updateQueryParam("job", job);
        this.updateQueryParam("offset", offset);
    }

    public GetObjectRequest withJob(UUID job) {
        this.job = job.toString();
        this.updateQueryParam("job", job);
        return this;
    }

    public GetObjectRequest withJob(String job) {
        this.job = job;
        this.updateQueryParam("job", job);
        return this;
    }

    public GetObjectRequest withOffset(long offset) {
        this.offset = offset;
        this.updateQueryParam("offset", offset);
        return this;
    }

    public GetObjectRequest withChecksum(ChecksumType checksum) {
        return this.withChecksum(checksum, ChecksumType.Type.MD5);
    }

    public GetObjectRequest withChecksum(ChecksumType checksum, ChecksumType.Type checksumType) {
        this.checksum = checksum;
        this.checksumType = checksumType;
        return this;
    }

    @Override
    public ChecksumType getChecksum() {
        return this.checksum;
    }

    @Override
    public ChecksumType.Type getChecksumType() {
        return this.checksumType;
    }

    public GetObjectRequest withByteRanges(Range ... byteRanges) {
        if (byteRanges != null) {
            this.setRanges((ImmutableList<Range>)ImmutableList.copyOf((Object[])byteRanges));
        }
        return this;
    }

    public GetObjectRequest withByteRanges(Collection<Range> byteRanges) {
        if (byteRanges != null) {
            this.setRanges((ImmutableList<Range>)ImmutableList.copyOf(byteRanges));
        }
        return this;
    }

    private void setRanges(ImmutableList<Range> byteRanges) {
        this.byteRanges = byteRanges;
        if (this.getHeaders().containsKey("Range")) {
            this.getHeaders().removeAll("Range");
        }
        this.getHeaders().put("Range", GetObjectRequest.buildRangeHeaderText(byteRanges));
    }

    private static String buildRangeHeaderText(ImmutableList<Range> byteRanges) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Range range : byteRanges) {
            builder.add((Object)String.format("%d-%d", range.getStart(), range.getEnd()));
        }
        Joiner stringJoiner = Joiner.on((String)",");
        return "bytes=" + stringJoiner.join((Iterable)builder.build());
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    @Override
    public String getContentType() {
        return ContentType.APPLICATION_OCTET_STREAM.getMimeType();
    }

    public WritableByteChannel getChannel() {
        return this.channel;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getJob() {
        return this.job;
    }

    public long getOffset() {
        return this.offset;
    }

    public Collection<Range> getByteRanges() {
        return this.byteRanges;
    }
}

