/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.spectralogic.ds3client.models.SignatureDetails;
import java.nio.charset.Charset;
import java.security.SignatureException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Signature {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String calculateRFC2104HMAC(String data, String key) throws SignatureException {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(Charset.forName("UTF-8")), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(Charset.forName("UTF-8")));
            result = Base64.encodeBase64String((byte[])rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result.trim();
    }

    public static String signature(SignatureDetails signatureDetails) throws SignatureException {
        return Signature.calculateRFC2104HMAC(String.valueOf((Object)signatureDetails.getVerb()) + '\n' + signatureDetails.getContentMd5() + '\n' + signatureDetails.getContentType() + '\n' + signatureDetails.getDate() + '\n' + signatureDetails.getCanonicalizedAmzHeaders() + signatureDetails.getCanonicalizedResource(), signatureDetails.getCredentials().getKey());
    }
}

