/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceUtils.class);

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static void logMbps(long startTime, long endTime, long totalBytes, String objName, boolean isPutCommand) {
        double time = endTime - startTime == 0L ? 1.0 : (double)(endTime - startTime) / 1000.0;
        double content = (double)totalBytes / 1024.0 / 1024.0;
        double mbps = content / time;
        String messagePrefix = isPutCommand ? "Putting" : "Getting";
        LOG.info(String.format("%s %s statistics: Length (%.03f MB), Time (%.03f sec), MBps (%.03f)", messagePrefix, objName, content, time, mbps));
    }
}

