/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.ObjectPartTracker;
import com.spectralogic.ds3client.helpers.ObjectPartTrackerImpl;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

class JobPartTrackerFactory {
    JobPartTrackerFactory() {
    }

    public static JobPartTracker buildPartTracker(Iterable<BulkObject> objects) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (BulkObject bulkObject : (Iterable)Preconditions.checkNotNull(objects)) {
            multimap.put((Object)bulkObject.getName(), (Object)new ObjectPart(bulkObject.getOffset(), bulkObject.getLength()));
        }
        return new JobPartTracker(new HashMap<String, ObjectPartTracker>(Maps.transformEntries((Map)multimap.asMap(), (Maps.EntryTransformer)new BuildObjectPartTrackerFromObjectPartGroup())));
    }

    private static final class BuildObjectPartTrackerFromObjectPartGroup
    implements Maps.EntryTransformer<String, Collection<ObjectPart>, ObjectPartTracker> {
        private BuildObjectPartTrackerFromObjectPartGroup() {
        }

        public ObjectPartTracker transformEntry(@Nonnull String key, @Nonnull Collection<ObjectPart> value) {
            return new ObjectPartTrackerImpl((String)Preconditions.checkNotNull((Object)key), (Collection)Preconditions.checkNotNull(value));
        }
    }
}

