/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.ObjectPartTracker;
import java.util.Map;

public class JobPartTracker {
    private final Map<String, ObjectPartTracker> trackers;

    public JobPartTracker(Map<String, ObjectPartTracker> trackers) {
        this.trackers = trackers;
    }

    public void completePart(String key, ObjectPart objectPart) {
        this.trackers.get(key).completePart(objectPart);
    }

    public boolean containsPart(String key, ObjectPart objectPart) {
        return this.trackers.get(key).containsPart(objectPart);
    }

    public JobPartTracker attachDataTransferredListener(DataTransferredListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.attachDataTransferredListener(listener);
        }
        return this;
    }

    public JobPartTracker attachObjectCompletedListener(ObjectCompletedListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.attachObjectCompletedListener(listener);
        }
        return this;
    }

    public void removeDataTransferredListener(DataTransferredListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.removeDataTransferredListener(listener);
        }
    }

    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.removeObjectCompletedListener(listener);
        }
    }
}

