/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class AutoCloseableCache<Key, Value extends AutoCloseable>
implements AutoCloseable {
    private final ValueBuilder<Key, Value> valueBuilder;
    private final Set<Key> closedKeys = new HashSet<Key>();
    private Map<Key, Value> values = new HashMap<Key, Value>();

    public AutoCloseableCache(ValueBuilder<Key, Value> valueBuilder) {
        this.valueBuilder = valueBuilder;
    }

    public synchronized Value get(Key key) {
        if (this.values == null) {
            throw new IllegalStateException("Cache already closed.");
        }
        if (this.closedKeys.contains(key)) {
            throw new IllegalStateException("Cache has already closed the requested key.");
        }
        AutoCloseable value = (AutoCloseable)this.values.get(key);
        if (value == null) {
            value = this.valueBuilder.get(key);
            this.values.put(key, value);
        }
        return (Value)value;
    }

    public synchronized void close(Key key) throws Exception {
        if (this.values == null) {
            throw new IllegalStateException("Cache already closed.");
        }
        AutoCloseable value = (AutoCloseable)this.values.remove(key);
        if (value != null) {
            value.close();
        }
        this.closedKeys.add(key);
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.values != null) {
            for (AutoCloseable value : this.values.values()) {
                value.close();
            }
            this.values = null;
        }
    }

    public static interface ValueBuilder<Key, Value extends AutoCloseable> {
        public Value get(Key var1);
    }
}

