/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.models.S3ObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetObjectsResponse
extends AbstractResponse {
    private S3ObjectList s3ObjectList;

    public GetObjectsResponse(WebResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void processResponse() throws IOException {
        try (WebResponse response = this.getResponse();){
            this.checkStatusCode(200);
            this.s3ObjectList = GetObjectsResponse.parseS3ObjectList(response);
        }
    }

    private static S3ObjectList parseS3ObjectList(WebResponse webResponse) throws IOException {
        try (InputStream content = webResponse.getResponseStream();){
            S3ObjectList s3ObjectList = XmlOutput.fromXml(content, S3ObjectList.class);
            return s3ObjectList;
        }
    }

    public S3ObjectList getS3ObjectList() {
        return this.s3ObjectList;
    }
}

