/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.commands.MetadataImpl;
import com.spectralogic.ds3client.exceptions.ContentLengthNotMatchException;
import com.spectralogic.ds3client.networking.Metadata;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.utils.IOUtils;
import com.spectralogic.ds3client.utils.PerformanceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.WritableByteChannel;

public class GetObjectResponse
extends AbstractResponse {
    private Metadata metadata;
    private long objectSize;

    public GetObjectResponse(WebResponse response, WritableByteChannel destinationChannel, int bufferSize, String objName) throws IOException {
        super(response);
        this.download(destinationChannel, bufferSize, objName);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    protected void processResponse() throws IOException {
        this.checkStatusCode(200, 206);
        this.metadata = new MetadataImpl(this.getResponse().getHeaders());
        this.objectSize = GetObjectResponse.getSizeFromHeaders(this.getResponse().getHeaders());
    }

    protected void download(WritableByteChannel destinationChannel, int bufferSize, String objName) throws IOException {
        try (WebResponse response = this.getResponse();
             InputStream responseStream = response.getResponseStream();){
            long startTime = PerformanceUtils.getCurrentTime();
            long totalBytes = IOUtils.copy(responseStream, destinationChannel, bufferSize);
            destinationChannel.close();
            long endTime = PerformanceUtils.getCurrentTime();
            if (this.objectSize != -1L && totalBytes != this.objectSize) {
                throw new ContentLengthNotMatchException(objName, this.objectSize, totalBytes);
            }
            PerformanceUtils.logMbps(startTime, endTime, totalBytes, objName, false);
        }
    }

    public long getObjectSize() {
        return this.objectSize;
    }
}

