/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.commands.RetryAfterExpectedException;
import com.spectralogic.ds3client.models.bulk.Objects;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class AllocateJobChunkResponse
extends AbstractResponse {
    private Status status;
    private Objects objects;
    private int retryAfterSeconds;

    public AllocateJobChunkResponse(WebResponse response) throws IOException {
        super(response);
    }

    public Status getStatus() {
        return this.status;
    }

    public Objects getObjects() {
        return this.objects;
    }

    public int getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processResponse() throws IOException {
        try (WebResponse response = this.getResponse();){
            this.checkStatusCode(200, 503);
            switch (this.getStatusCode()) {
                case 200: {
                    this.status = Status.ALLOCATED;
                    this.objects = AllocateJobChunkResponse.parseChunk(response);
                    return;
                }
                case 503: {
                    this.status = Status.RETRYLATER;
                    this.retryAfterSeconds = AllocateJobChunkResponse.parseRetryAfter(response);
                    return;
                }
                default: {
                    assert (false) : "checkStatusCode should have made it impossible to reach this line.";
                    return;
                }
            }
        }
    }

    private static Objects parseChunk(WebResponse webResponse) throws IOException {
        try (InputStream content = webResponse.getResponseStream();){
            Objects objects = XmlOutput.fromXml(content, Objects.class);
            return objects;
        }
    }

    private static int parseRetryAfter(WebResponse webResponse) {
        String retryAfter = webResponse.getHeaders().get("Retry-After").get(0);
        if (retryAfter == null) {
            throw new RetryAfterExpectedException();
        }
        return Integer.parseInt(retryAfter);
    }

    public static enum Status {
        ALLOCATED,
        RETRYLATER;

    }
}

