/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.spectralogic.ds3client.models.Credentials;
import com.spectralogic.ds3client.models.bulk.Node;
import com.spectralogic.ds3client.networking.ConnectionDetails;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionDetailsImpl
implements ConnectionDetails {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionDetailsImpl.class);
    private final String endpoint;
    private final Credentials credentials;
    private final boolean https;
    private final URI proxy;
    private final int retries;
    private final int bufferSize;
    private final boolean certificateVerification;

    public static ConnectionDetails newForNode(Node node, ConnectionDetails connectionDetails) {
        Builder connectionBuilder;
        if (node.getEndpoint() == null || node.getEndpoint().equals("FAILED_TO_DETERMINE_DATAPATH_IP_ADDRESS")) {
            LOG.trace("Running against an old version of the DS3 API, reusing existing endpoint configuration");
            connectionBuilder = ConnectionDetailsImpl.builder(connectionDetails.getEndpoint(), connectionDetails.getCredentials());
        } else {
            LOG.trace("Creating new Connection Details for endpoint: " + node.getEndpoint());
            connectionBuilder = ConnectionDetailsImpl.builder(ConnectionDetailsImpl.buildAuthority(node, connectionDetails), connectionDetails.getCredentials());
        }
        connectionBuilder.withRedirectRetries(connectionDetails.getRetries()).withHttps(connectionDetails.isHttps()).withCertificateVerification(connectionDetails.isCertificateVerification()).withBufferSize(connectionDetails.getBufferSize()).withProxy(connectionDetails.getProxy());
        return connectionBuilder.build();
    }

    private static String buildAuthority(Node node, ConnectionDetails connectionDetails) {
        return node.getEndpoint() + ":" + Integer.toString(connectionDetails.isHttps() ? node.getHttpsPort() : node.getHttpPort());
    }

    static Builder builder(String uriEndpoint, Credentials credentials) {
        return new Builder(uriEndpoint, credentials);
    }

    private ConnectionDetailsImpl(Builder builder) {
        this.endpoint = builder.endpoint;
        this.credentials = builder.credentials;
        this.https = builder.https;
        this.proxy = builder.proxy;
        this.retries = builder.retries;
        this.bufferSize = builder.bufferSize;
        this.certificateVerification = builder.certificateVerification;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public boolean isHttps() {
        return this.https;
    }

    @Override
    public URI getProxy() {
        return this.proxy;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean isCertificateVerification() {
        return this.certificateVerification;
    }

    public String toString() {
        return "Endpoint: " + this.endpoint + " | Https?: " + this.https;
    }

    static class Builder
    implements com.spectralogic.ds3client.utils.Builder<ConnectionDetailsImpl> {
        private final String endpoint;
        private final Credentials credentials;
        private boolean https = false;
        private URI proxy = null;
        private int retries = 5;
        private int bufferSize = 0x100000;
        private boolean certificateVerification;

        private Builder(String endpoint, Credentials credentials) {
            this.endpoint = endpoint;
            this.credentials = credentials;
        }

        public Builder withHttps(boolean secure) {
            this.https = secure;
            return this;
        }

        public Builder withProxy(URI proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withRedirectRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withCertificateVerification(boolean certificateVerification) {
            this.certificateVerification = certificateVerification;
            return this;
        }

        @Override
        public ConnectionDetailsImpl build() {
            return new ConnectionDetailsImpl(this);
        }
    }
}

