/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpit.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import org.jets3t.service.model.S3Object;

public class ObjectTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 8570725021470237261L;
    private ArrayList objectList = new ArrayList();

    public ObjectTableModel() {
        super(new String[]{"Object Key", "Size", "Last Modified"}, 0);
    }

    public int addObject(S3Object object) {
        int insertRow = Collections.binarySearch(this.objectList, object, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((S3Object)o1).getKey().compareToIgnoreCase(((S3Object)o2).getKey());
            }
        });
        if (insertRow >= 0) {
            this.objectList.remove(insertRow);
            this.removeRow(insertRow);
        } else {
            insertRow = -insertRow - 1;
        }
        this.objectList.add(insertRow, object);
        this.insertRow(insertRow, new Object[]{object.getKey(), new Long(object.getContentLength()), object.getLastModifiedDate()});
        return insertRow;
    }

    public void addObjects(S3Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.addObject(objects[i]);
        }
    }

    public void removeObject(S3Object object) {
        int index = this.objectList.indexOf(object);
        if (index >= 0) {
            this.removeRow(index);
            this.objectList.remove(object);
        }
    }

    public void removeAllObjects() {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.removeRow(0);
        }
        this.objectList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Object getObject(int row) {
        ArrayList arrayList = this.objectList;
        synchronized (arrayList) {
            return (S3Object)this.objectList.get(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Object getObjectByKey(String key) {
        ArrayList arrayList = this.objectList;
        synchronized (arrayList) {
            for (S3Object object : this.objectList) {
                if (!object.getKey().equals(key)) continue;
                return object;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Object[] getObjects() {
        ArrayList arrayList = this.objectList;
        synchronized (arrayList) {
            return this.objectList.toArray(new S3Object[this.objectList.size()]);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return Long.class;
        }
        return Date.class;
    }
}

