/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class AzureCopyFeature
implements Copy {
    private static final Logger log = Logger.getLogger(AzureCopyFeature.class);
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();

    public AzureCopyFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
    }

    public Path copy(Path source, Path copy, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            CloudAppendBlob target = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(copy).getName()).getAppendBlobReference(this.containerService.getKey(copy));
            CloudBlob blob = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(source).getName()).getBlobReferenceFromServer(this.containerService.getKey(source));
            BlobRequestOptions options = new BlobRequestOptions();
            options.setStoreBlobContentMD5(Boolean.valueOf(PreferencesFactory.get().getBoolean("azure.upload.md5")));
            URI s = this.session.getHost().getCredentials().isTokenAuthentication() ? URI.create(blob.getUri().toString() + this.session.getHost().getCredentials().getToken()) : blob.getUri();
            String id = target.startCopy(s, AccessCondition.generateEmptyCondition(), AccessCondition.generateEmptyCondition(), options, this.context);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Started copy for %s with copy operation ID %s", copy, id));
            }
            return copy;
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }

    public Copy withTarget(Session<?> session) {
        return this;
    }
}

