/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2BucketTypeFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.LifecycleRule;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;

public class B2LifecycleFeature
implements Lifecycle {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;

    public B2LifecycleFeature(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public LifecycleConfiguration getConfiguration(Path container) throws BackgroundException {
        try {
            List buckets = ((B2ApiClient)this.session.getClient()).listBuckets();
            for (B2BucketResponse response : buckets) {
                if (!response.getBucketName().equals(this.containerService.getContainer(container).getName())) continue;
                List lifecycleRules = response.getLifecycleRules();
                Iterator iterator = lifecycleRules.iterator();
                if (iterator.hasNext()) {
                    LifecycleRule rule = (LifecycleRule)iterator.next();
                    return new LifecycleConfiguration(null == rule.getDaysFromUploadingToHiding() ? null : Integer.valueOf(rule.getDaysFromUploadingToHiding().intValue()), null, null == rule.getDaysFromHidingToDeleting() ? null : Integer.valueOf(rule.getDaysFromHidingToDeleting().intValue()));
                }
                return LifecycleConfiguration.empty();
            }
            throw new NotfoundException(container.getAbsolute());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e, container);
        }
    }

    public void setConfiguration(Path container, LifecycleConfiguration configuration) throws BackgroundException {
        try {
            ((B2ApiClient)this.session.getClient()).updateBucket(this.fileid.getFileid(this.containerService.getContainer(container), (ListProgressListener)new DisabledListProgressListener()), new B2BucketTypeFeature(this.session, this.fileid).convert(container.attributes().getAcl()), new LifecycleRule[]{new LifecycleRule(null == configuration.getExpiration() ? null : Long.valueOf(configuration.getExpiration().longValue()), null == configuration.getTransition() ? null : Long.valueOf(configuration.getTransition().longValue()), "")});
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map("Failure to write attributes of {0}", e, container);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e, container);
        }
    }
}

