/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.ExpiredTokenException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2ErrorResponseInterceptor
extends DisabledServiceUnavailableRetryStrategy
implements HttpRequestInterceptor {
    private static final Logger log = Logger.getLogger(B2ErrorResponseInterceptor.class);
    private static final int MAX_RETRIES = 1;
    private final B2Session session;
    private String accountId = "";
    private String applicationKey = "";
    private String authorizationToken = "";

    public B2ErrorResponseInterceptor(B2Session session) {
        this.session = session;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount > 1) break;
                try {
                    EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                    B2ApiException failure = new B2ApiException(EntityUtils.toString((HttpEntity)response.getEntity()), (Throwable)new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    if (new B2ExceptionMappingService().map(failure) instanceof ExpiredTokenException) {
                        try {
                            this.authorizationToken = ((B2ApiClient)this.session.getClient()).authenticate(this.accountId, this.applicationKey).getAuthorizationToken();
                            return true;
                        }
                        catch (IOException | B2ApiException e) {
                            log.warn((Object)String.format("Attempt to renew expired auth token failed. %s", e.getMessage()));
                            return false;
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    log.warn((Object)String.format("Failure parsing response entity from %s", response));
                    return false;
                }
            }
        }
        return false;
    }

    public void setTokens(String accountId, String applicationKey, String authorizationToken) {
        this.accountId = accountId;
        this.applicationKey = applicationKey;
        this.authorizationToken = authorizationToken;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (StringUtils.contains((CharSequence)request.getRequestLine().getUri(), (CharSequence)"b2_authorize_account")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip setting token in b2_authorize_account");
            }
            return;
        }
        switch (request.getRequestLine().getMethod()) {
            case "POST": {
                break;
            }
            default: {
                if (!StringUtils.isNotBlank((CharSequence)this.authorizationToken)) break;
                request.removeHeaders("Authorization");
                request.addHeader("Authorization", this.authorizationToken);
            }
        }
    }
}

