/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructFileExtAndRegInp
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "StructFileExtAndRegInp_PI";
    public static final String OBJ_PATH = "objPath";
    public static final String COLLECTION = "collection";
    public static final String OPR_TYPE = "oprType";
    public static final String FLAGS = "flags";
    public static final String FORCE_FLAG_KW = "forceFlag";
    public static final String BULK_OPERATION_KW = "bulkOpr";
    public static final String RESOURCE_NAME_KW = "rescName";
    public static final String DEST_RESOURCE_NAME_KW = "destRescName";
    public static final String DATA_TYPE = "dataType";
    public static final String TAR_DATA_TYPE_KW_VALUE = "tar file";
    public static final int STRUCT_FILE_EXTRACT_AND_REG_API_NBR = 665;
    public static final int STRUCT_FILE_BUNDLE_API_NBR = 666;
    public static final int DEFAULT_OPERATION_TYPE = 0;
    private ForceOptions forceOption = ForceOptions.NO_FORCE;
    private static final Logger LOG = LoggerFactory.getLogger(StructFileExtAndRegInp.class);
    private final String tarFileAbsolutePath;
    private final String tarCollectionAbsolutePath;
    private final int operationType;
    private final String resourceName;
    private final boolean extractAsBulkOperation;

    public static final StructFileExtAndRegInp instanceForExtractBundleNoForce(String tarFileAbsolutePath, String tarCollectionAbsolutePath, String resourceNameToStoreTo) {
        return new StructFileExtAndRegInp(665, tarFileAbsolutePath, tarCollectionAbsolutePath, ForceOptions.NO_FORCE, resourceNameToStoreTo, false);
    }

    public static final StructFileExtAndRegInp instanceForExtractBundleNoForceWithBulkOperation(String tarFileAbsolutePath, String tarCollectionAbsolutePath, String resourceNameToStoreTo) {
        return new StructFileExtAndRegInp(665, tarFileAbsolutePath, tarCollectionAbsolutePath, ForceOptions.NO_FORCE, resourceNameToStoreTo, true);
    }

    public static final StructFileExtAndRegInp instanceForExtractBundleWithForceOption(String tarFileAbsolutePath, String tarCollectionAbsolutePath, String resourceNameToStoreTo) {
        return new StructFileExtAndRegInp(665, tarFileAbsolutePath, tarCollectionAbsolutePath, ForceOptions.FORCE, resourceNameToStoreTo, false);
    }

    public static final StructFileExtAndRegInp instanceForExtractBundleWithForceOptionAndBulkOperation(String tarFileAbsolutePath, String tarCollectionAbsolutePath, String resourceNameToStoreTo) {
        return new StructFileExtAndRegInp(665, tarFileAbsolutePath, tarCollectionAbsolutePath, ForceOptions.FORCE, resourceNameToStoreTo, true);
    }

    public static final StructFileExtAndRegInp instanceForCreateBundle(String tarFileToCreateAbsolutePath, String irodsSourceCollectionForTarAbsolutePath, String resourceNameThatIsSourceForTarFile) {
        return new StructFileExtAndRegInp(666, tarFileToCreateAbsolutePath, irodsSourceCollectionForTarAbsolutePath, ForceOptions.NO_FORCE, resourceNameThatIsSourceForTarFile, false);
    }

    public static final StructFileExtAndRegInp instanceForCreateBundleWithForceOption(String tarFileToCreateAbsolutePath, String irodsSourceCollectionForTarAbsolutePath, String resourceNameThatIsSourceForTarFile) {
        return new StructFileExtAndRegInp(666, tarFileToCreateAbsolutePath, irodsSourceCollectionForTarAbsolutePath, ForceOptions.FORCE, resourceNameThatIsSourceForTarFile, false);
    }

    private StructFileExtAndRegInp(int apiNumber, String tarFileAbsolutePath, String tarCollectionAbsolutePath, ForceOptions forceOption, String resourceName, boolean extractAsBulkOperation) {
        if (tarFileAbsolutePath == null || tarFileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("tarFileAbsolutePath is null or empty");
        }
        if (tarCollectionAbsolutePath == null || tarCollectionAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("tarCollectionAbsolutePath is null or empty");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName is null");
        }
        this.tarFileAbsolutePath = tarFileAbsolutePath;
        this.tarCollectionAbsolutePath = tarCollectionAbsolutePath;
        this.setApiNumber(apiNumber);
        this.forceOption = forceOption;
        this.operationType = 0;
        this.resourceName = resourceName;
        this.extractAsBulkOperation = extractAsBulkOperation;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag(PI_TAG, new Tag[]{new Tag(OBJ_PATH, this.tarFileAbsolutePath), new Tag(COLLECTION, this.tarCollectionAbsolutePath), new Tag(OPR_TYPE, 0), new Tag(FLAGS, 0)});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        kvps.add(KeyValuePair.instance(DATA_TYPE, TAR_DATA_TYPE_KW_VALUE));
        if (this.resourceName.length() > 0) {
            LOG.debug("resourceName is specified, add resource keywords");
            kvps.add(KeyValuePair.instance(DEST_RESOURCE_NAME_KW, this.resourceName));
            kvps.add(KeyValuePair.instance(RESOURCE_NAME_KW, this.resourceName));
        }
        if (this.forceOption == ForceOptions.FORCE) {
            LOG.debug("adding force flag");
            kvps.add(KeyValuePair.instance(FORCE_FLAG_KW, ""));
        }
        if (this.isExtractAsBulkOperation()) {
            LOG.debug("adding bulk operation flag");
            kvps.add(KeyValuePair.instance(BULK_OPERATION_KW, ""));
        }
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    public ForceOptions getForceOption() {
        return this.forceOption;
    }

    public void setForceOption(ForceOptions forceOption) {
        this.forceOption = forceOption;
    }

    public String getTarFileAbsolutePath() {
        return this.tarFileAbsolutePath;
    }

    public String getTarCollectionAbsolutePath() {
        return this.tarCollectionAbsolutePath;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    protected boolean isExtractAsBulkOperation() {
        return this.extractAsBulkOperation;
    }

    public static enum ForceOptions {
        FORCE,
        NO_FORCE;

    }
}

