/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import io.mikael.urlbuilder.util.Decoder;
import io.mikael.urlbuilder.util.Encoder;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MantaUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaUtils.class);
    private static final Encoder UTF8_URL_ENCODER = new Encoder(StandardCharsets.UTF_8);
    private static final Decoder UTF8_URL_DECODER = new Decoder(StandardCharsets.UTF_8);

    private MantaUtils() {
    }

    public static boolean endsWith(StringBuilder builder, char match) {
        Validate.notNull((Object)builder, (String)"StringBuilder object must not be null", (Object[])new Object[0]);
        if (builder.length() == 0) {
            return false;
        }
        char last = builder.subSequence(builder.length() - 1, builder.length()).charAt(0);
        return last == match;
    }

    public static String toStringEmptyToNull(Object value) {
        if (value == null) {
            return null;
        }
        String stringValue = value.toString();
        if (stringValue.isEmpty()) {
            return null;
        }
        return stringValue;
    }

    public static Integer parseIntegerOrNull(Object value) {
        Integer parsed;
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String string = MantaUtils.toStringEmptyToNull(value);
        if (string == null) {
            return null;
        }
        try {
            parsed = Integer.parseInt(string);
        }
        catch (Exception e) {
            String msg = "Error parsing value as integer. Value: %s";
            LOGGER.warn(String.format(msg, value), (Throwable)e);
            parsed = null;
        }
        return parsed;
    }

    public static Boolean parseBooleanOrNull(Object value) {
        Boolean parsed;
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String string = MantaUtils.toStringEmptyToNull(value);
        if (string == null) {
            return null;
        }
        if (string.equals("1")) {
            return true;
        }
        if (string.equals("0")) {
            return false;
        }
        try {
            parsed = BooleanUtils.toBoolean((String)string);
        }
        catch (Exception e) {
            String msg = "Error parsing value as boolean. Value: %s";
            LOGGER.warn(String.format(msg, value), (Throwable)e);
            parsed = null;
        }
        return parsed;
    }

    public static <T extends Enum<T>> T parseEnumOrNull(Object value, Class<T> enumClass) {
        T parsed;
        if (value == null) {
            return null;
        }
        if (value.getClass() == enumClass) {
            Enum cast = (Enum)value;
            return (T)cast;
        }
        String string = MantaUtils.toStringEmptyToNull(value);
        if (string == null) {
            return null;
        }
        try {
            parsed = Enum.valueOf(enumClass, string);
        }
        catch (RuntimeException e) {
            String msg = "Error parsing value as enum. Value: %s";
            LOGGER.warn(String.format(msg, value), (Throwable)e);
            parsed = null;
        }
        return parsed;
    }

    public static String formatPath(String path) {
        return UTF8_URL_ENCODER.encodePath(path);
    }

    public static String decodePath(String encodedPath) {
        return UTF8_URL_DECODER.decodePath(encodedPath);
    }

    public static String[] parseAccount(String account) {
        Validate.notNull((Object)account, (String)"Account must not be null", (Object[])new Object[0]);
        int slashPos = account.indexOf("/");
        if (account.isEmpty()) {
            throw new IllegalArgumentException("Username can't be empty");
        }
        if (slashPos == -1) {
            return new String[]{account};
        }
        if (slashPos == 0) {
            throw new IllegalArgumentException("Username can't begin with /");
        }
        if (account.charAt(account.length() - 1) == '/') {
            throw new IllegalArgumentException("Username can't end with /");
        }
        String username = account.substring(0, slashPos);
        String subuser = account.substring(slashPos + 1);
        return new String[]{username, subuser};
    }

    public static String asString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            try {
                Field field = enumValue.getClass().getField(enumValue.name());
                Validate.notNull((Object)field, (String)"A non-null field should always be returned. Enum constant missing @Value or @NullValue annotation: %s", (Object[])new Object[]{enumValue});
            }
            catch (NoSuchFieldException e) {
                String msg = String.format("Could not find name field for enum: %s", value);
                LOGGER.warn(msg, (Throwable)e);
                return null;
            }
        } else {
            if (value instanceof Iterable) {
                StringBuilder sb = new StringBuilder();
                Iterator itr = ((Iterable)value).iterator();
                while (itr.hasNext()) {
                    Object next = itr.next();
                    if (next != null) {
                        sb.append(next.toString());
                    }
                    if (!itr.hasNext()) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.length; ++i) {
                    Object next = array[i];
                    if (next != null) {
                        sb.append(next.toString());
                    }
                    if (i >= array.length - 1) continue;
                    sb.append(", ");
                }
                return sb.toString();
            }
        }
        return value.toString();
    }

    public static Collection<String> fromCsv(String line) {
        Validate.notNull((Object)line, (String)"Line must not be null", (Object[])new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        if (line.contains(",")) {
            String[] parts = line.split(",\\s*");
            Collections.addAll(list, parts);
        } else {
            list.add(line);
        }
        return list;
    }

    public static String lastItemInPath(String path) {
        Validate.notEmpty((CharSequence)path, (String)"Path must not be null nor empty", (Object[])new Object[0]);
        Path asNioPath = Paths.get(path, new String[0]);
        int count = asNioPath.getNameCount();
        if (count < 1) {
            throw new IllegalArgumentException("Path doesn't have a single element to parse");
        }
        Path lastPart = asNioPath.getName(count - 1);
        return lastPart.toString();
    }

    public static String[] prefixPaths(String rawPath) {
        String[] parts = StringUtils.split((String)rawPath, (char)"/".charAt(0));
        Iterator<Path> itr = Paths.get("", parts).iterator();
        StringBuilder sb = new StringBuilder("/");
        String[] paths = new String[parts.length];
        int i = 0;
        while (itr.hasNext()) {
            String part = itr.next().toString();
            sb.append(part);
            paths[i] = sb.toString();
            if (itr.hasNext()) {
                sb.append("/");
            }
            ++i;
        }
        return paths;
    }

    public static String[] writeablePrefixPaths(String rawPath) {
        String[] paths = MantaUtils.prefixPaths(rawPath);
        return Arrays.copyOfRange(MantaUtils.prefixPaths(rawPath), 2, paths.length);
    }

    public static Map<String, String> asStringMap(Map<String, ?> map) {
        Validate.notNull(map, (String)"Map must not be null", (Object[])new Object[0]);
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>(map.size());
        Map<String, ?> objectMap = map;
        Set<Map.Entry<String, ?>> entrySet = objectMap.entrySet();
        for (Map.Entry<String, ?> next : entrySet) {
            Object obj = next.getValue();
            String value = obj == null || obj instanceof String ? (String)obj : (obj instanceof InetAddress ? ((InetAddress)obj).getHostAddress() : (obj instanceof Map ? MantaUtils.csv((Map)obj) : (obj instanceof Iterable ? MantaUtils.csv((Iterable)obj) : (obj instanceof CharSequence ? String.valueOf(obj) : obj.toString()))));
            stringMap.put(next.getKey(), value);
        }
        return Collections.unmodifiableMap(stringMap);
    }

    public static String csv(Map<?, ?> map) {
        Validate.notNull(map, (String)"Map must not be null", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder();
        Map<?, ?> noGenericsMap = map;
        Set<Map.Entry<?, ?>> set = noGenericsMap.entrySet();
        Iterator<Map.Entry<?, ?>> itr = set.iterator();
        while (itr.hasNext()) {
            Map.Entry<?, ?> entry = itr.next();
            if (entry == null || entry.getKey() == null) continue;
            builder.append(entry.getKey().toString()).append(": ").append(String.valueOf(entry.getValue()));
            if (!itr.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String csv(Iterable<?> stringable) {
        if (stringable == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<?> itr = stringable.iterator();
        while (itr.hasNext()) {
            String value;
            Object o = itr.next();
            if (o == null) continue;
            if (o instanceof InetAddress) {
                value = ((InetAddress)o).getHostAddress();
            } else if (o instanceof Map) {
                StringBuilder sb = new StringBuilder();
                Map map = (Map)o;
                Iterator mapItr = map.entrySet().iterator();
                while (mapItr.hasNext()) {
                    Map.Entry entry = mapItr.next();
                    sb.append("[").append(String.valueOf(entry.getKey())).append("=").append(entry.getValue()).append("]");
                    if (!mapItr.hasNext()) continue;
                    sb.append(" ");
                }
                value = sb.toString();
            } else {
                value = o.toString();
            }
            builder.append(StringUtils.replaceChars((String)value, (char)',', (char)' '));
            if (!itr.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static String[] csv2array(String line) {
        Validate.notNull((Object)line, (String)"Line must not be null", (Object[])new Object[0]);
        if (line.contains(",")) {
            return line.split(",\\s*");
        }
        return new String[]{line};
    }

    public static void attachExceptionsToContext(ExceptionContext contexted, Iterable<? extends Exception> exceptions) {
        int count = 1;
        for (Exception exception : exceptions) {
            String label = String.format("exception_%d", count++);
            contexted.setContextValue(label, (Object)exception);
        }
    }

    public static Date parseHttpDate(String date) {
        return DateUtils.parseDate((String)date);
    }

    public static String byteArrayAsHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Hex.encodeHexString((byte[])bytes);
    }

    public static <K, V> Map<K, V> unmodifiableMap(K key1, V val1) {
        Map<K, V> map = Collections.singletonMap(key1, val1);
        map.put(key1, val1);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableMap(K key1, V val1, K key2, V val2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(2);
        map.put(key1, val1);
        map.put(key2, val2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableMap(K key1, V val1, K key2, V val2, K key3, V val3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(3);
        map.put(key1, val1);
        map.put(key2, val2);
        map.put(key3, val3);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> unmodifiableMap(K key1, V val1, Object ... nPairs) {
        if (nPairs == null) {
            return MantaUtils.unmodifiableMap(key1, val1);
        }
        if (nPairs.length % 2 != 0) {
            throw new IllegalArgumentException("Vararg must be provided in even numbers");
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1 + nPairs.length / 2);
        map.put(key1, val1);
        Object key = null;
        for (int i = 0; i < nPairs.length; ++i) {
            if (i % 2 == 0) {
                key = nPairs[i];
                continue;
            }
            Object val = nPairs[i];
            map.put(key, val);
        }
        return Collections.unmodifiableMap(map);
    }

    public static int overflowToIntMax(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }
}

