/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.config.AuthAwareConfigContext;
import com.joyent.manta.exception.ConfigurationException;
import com.joyent.manta.exception.MantaClientException;
import com.joyent.manta.http.DynamicHttpSignatureRequestInterceptor;
import com.joyent.manta.http.RequestIdInterceptor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicHeader;

public class MantaHttpRequestFactory {
    private static final Header[] HEADERS = new Header[]{new BasicHeader("accept-version", "~1.0"), new BasicHeader("Accept", "application/json, */*")};
    private static final RequestIdInterceptor INTERCEPTOR_REQUEST_ID = new RequestIdInterceptor();
    private final AuthAwareConfigContext authConfig;
    private final DynamicHttpSignatureRequestInterceptor authInterceptor;
    private final String url;

    public MantaHttpRequestFactory(AuthAwareConfigContext authConfig) {
        this.authConfig = (AuthAwareConfigContext)Validate.notNull((Object)authConfig, (String)"AuthAwareConfigContext must not be null", (Object[])new Object[0]);
        this.authInterceptor = new DynamicHttpSignatureRequestInterceptor(authConfig);
        this.url = null;
    }

    public MantaHttpRequestFactory(String url) {
        this.authConfig = null;
        this.authInterceptor = null;
        this.url = (String)Validate.notNull((Object)url, (String)"URL must not be null", (Object[])new Object[0]);
    }

    public HttpDelete delete(String path) {
        HttpDelete request = new HttpDelete(this.uriForPath(path));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpDelete delete(String path, List<NameValuePair> params) {
        HttpDelete request = new HttpDelete(this.uriForPath(path, params));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpGet get(String path) {
        HttpGet request = new HttpGet(this.uriForPath(path));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpGet get(String path, List<NameValuePair> params) {
        HttpGet request = new HttpGet(this.uriForPath(path, params));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpHead head(String path) {
        HttpHead request = new HttpHead(this.uriForPath(path));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpHead head(String path, List<NameValuePair> params) {
        HttpHead request = new HttpHead(this.uriForPath(path, params));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpPost post(String path) {
        HttpPost request = new HttpPost(this.uriForPath(path));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpPost post(String path, List<NameValuePair> params) {
        HttpPost request = new HttpPost(this.uriForPath(path, params));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpPut put(String path) {
        HttpPut request = new HttpPut(this.uriForPath(path));
        this.prepare((HttpRequest)request);
        return request;
    }

    public HttpPut put(String path, List<NameValuePair> params) {
        HttpPut request = new HttpPut(this.uriForPath(path, params));
        this.prepare((HttpRequest)request);
        return request;
    }

    private void prepare(HttpRequest request) {
        request.setHeaders(HEADERS);
        try {
            INTERCEPTOR_REQUEST_ID.process(request, null);
            if (this.authInterceptor != null) {
                this.authInterceptor.process(request, null);
            }
        }
        catch (IOException | HttpException e) {
            throw new MantaClientException("Failed to prepare request", e);
        }
    }

    public static void addHeaders(HttpMessage httpMessage, Header ... headers) {
        Validate.notNull((Object)httpMessage, (String)"HttpMessage must not be null", (Object[])new Object[0]);
        for (Header header : headers) {
            httpMessage.addHeader(header);
        }
    }

    protected String uriForPath(String path) {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        String format = path.startsWith("/") ? "%s%s" : "%s/%s";
        String baseURL = this.authConfig != null ? this.authConfig.getMantaURL() : this.url;
        return String.format(format, baseURL, path);
    }

    protected String uriForPath(String path, List<NameValuePair> params) {
        Validate.notNull((Object)path, (String)"Path must not be null", (Object[])new Object[0]);
        Validate.notNull(params, (String)"Params must not be null", (Object[])new Object[0]);
        try {
            URIBuilder uriBuilder = new URIBuilder(this.uriForPath(path));
            uriBuilder.addParameters(params);
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(String.format("Invalid path in URI: %s", path));
        }
    }
}

