/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.http.MantaConnectionContext;
import com.joyent.manta.http.MantaConnectionFactory;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.MDC;

public class MantaApacheHttpClientContext
implements MantaConnectionContext {
    private final CloseableHttpClient httpClient;
    private final MantaConnectionFactory connectionFactory;

    public MantaApacheHttpClientContext(MantaConnectionFactory connectionFactory) {
        Validate.notNull((Object)connectionFactory, (String)"Connection factory must not be null", (Object[])new Object[0]);
        this.connectionFactory = connectionFactory;
        this.httpClient = connectionFactory.createConnection();
    }

    @Override
    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void close() throws IOException {
        MDC.remove((String)"mantaRequestId");
        this.httpClient.close();
        this.connectionFactory.close();
    }
}

