/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.config.MapConfigContext;
import com.joyent.manta.config.SettableConfigContext;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigContextMBean
implements DynamicMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigContextMBean.class);
    private final WeakReference<ConfigContext> configRef;
    private final MBeanAttributeInfo[] beanAttributeInfo;
    private final MBeanInfo beanInfo;
    private final boolean isSettable;

    public ConfigContextMBean(ConfigContext config) {
        this.configRef = new WeakReference<ConfigContext>(config);
        this.isSettable = config instanceof SettableConfigContext;
        this.beanAttributeInfo = this.beanAttributeInfoBuilder();
        this.beanInfo = this.beanInfoBuilder(this.beanAttributeInfo);
    }

    private MBeanAttributeInfo[] beanAttributeInfoBuilder() {
        return new MBeanAttributeInfo[]{new MBeanAttributeInfo("manta.url", String.class.getName(), "The Manta server URL to connect to", true, this.isSettable, false), new MBeanAttributeInfo("manta.user", String.class.getName(), "User connecting to Manta", true, this.isSettable, false), new MBeanAttributeInfo("manta.key_id", String.class.getName(), "Fingerprint of RSA key used to generate HTTP signatures", true, this.isSettable, false), new MBeanAttributeInfo("manta.key_path", String.class.getName(), "Path on the file system to private key used to generate HTTP signatures", true, this.isSettable, false), new MBeanAttributeInfo("manta.timeout", Integer.class.getName(), "Connection timeout for the Manta service in milliseconds", true, this.isSettable, false), new MBeanAttributeInfo("manta.retries", Integer.class.getName(), "Number of times to retry failed requests", true, this.isSettable, false), new MBeanAttributeInfo("manta.max_connections", Integer.class.getName(), "Maximum number of open connections to the Manta API", true, this.isSettable, false), new MBeanAttributeInfo("https.protocols", String.class.getName(), "Comma delimited list of HTTPS protocols", true, this.isSettable, false), new MBeanAttributeInfo("manta.disable_native_sigs", Boolean.class.getName(), "Flag that disables using native code to generate HTTP signatures", true, false, false), new MBeanAttributeInfo("manta.http_buffer_size", Integer.class.getName(), "Size of buffer in bytes to use to buffer streams of HTTP data", true, this.isSettable, false), new MBeanAttributeInfo("manta.tcp_socket_timeout", Integer.class.getName(), "Time in milliseconds to wait to see if a TCP socket has timed out", true, this.isSettable, false), new MBeanAttributeInfo("manta.connection_request_timeout", Integer.class.getName(), "Time in milliseconds to wait for a connection from the pool", true, false, false), new MBeanAttributeInfo("manta.verify_uploads", Boolean.class.getName(), "Flag indicating the checksum verification of uploaded files is enabled", true, this.isSettable, false), new MBeanAttributeInfo("manta.upload_buffer_size", Integer.class.getName(), "The size of pre-streaming upload buffers", true, this.isSettable, false), new MBeanAttributeInfo("manta.skip_directory_depth", Integer.class.getName(), "The depth of directories to skip when attempting creating directories recursively", true, this.isSettable, false), new MBeanAttributeInfo("manta.client_encryption", Boolean.class.getName(), "Flag indicating client-side encryption is enabled", true, false, false), new MBeanAttributeInfo("manta.encryption_key_id", String.class.getName(), "The unique identifier of the key used for encryption", true, false, false), new MBeanAttributeInfo("manta.encryption_algorithm", String.class.getName(), "The client-side encryption algorithm", true, false, false), new MBeanAttributeInfo("manta.permit_unencrypted_downloads", Boolean.class.getName(), "Flag indicating that downloading unencrypted files is allowed in encryption mode", true, false, false), new MBeanAttributeInfo("manta.encryption_auth_mode", EncryptionAuthenticationMode.class.getName(), "Ciphertext authentication mode", true, false, false), new MBeanAttributeInfo("manta.encryption_key_path", String.class.getName(), "Path to the private encryption key on the filesystem", true, false, false)};
    }

    private MBeanInfo beanInfoBuilder(MBeanAttributeInfo[] attributeInfo) {
        MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[]{new MBeanConstructorInfo("ConfigContextConstructor", "Constructs a new instance based on a config context", new MBeanParameterInfo[]{new MBeanParameterInfo("ConfigContext", ConfigContext.class.getName(), "ConfigContext instance")})};
        return new MBeanInfo(ConfigContext.class.getName(), "Java Manta SDK Manta Client Configuration", attributeInfo, constructorInfo, new MBeanOperationInfo[0], new MBeanNotificationInfo[0]);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ConfigContext config = (ConfigContext)this.configRef.get();
        if (config == null) {
            throw new AttributeNotFoundException("Configuration context has been garbage collected");
        }
        Object result = ConfigContext.getAttributeFromContext(attribute, config);
        if (result == null) {
            String msg = String.format("Can't find MBean attribute: %s", attribute);
            throw new AttributeNotFoundException(msg);
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        boolean keyExists;
        if (!this.isSettable) {
            throw new UnsupportedOperationException("Can't set attributes for non-settable context");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        boolean bl = keyExists = Arrays.binarySearch(MapConfigContext.ALL_PROPERTIES, name) >= 0;
        if (!keyExists) {
            String msg = String.format("No attribute with the name [%s] found", name);
            throw new AttributeNotFoundException(msg);
        }
        ConfigContext config = (ConfigContext)this.configRef.get();
        if (config == null) {
            throw new AttributeNotFoundException("Configuration context has been garbage collected");
        }
        SettableConfigContext settable = (SettableConfigContext)config;
        SettableConfigContext.setAttributeFromContext(name, value, settable);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        ConfigContext config = (ConfigContext)this.configRef.get();
        if (config == null) {
            throw new IllegalStateException("Configuration context has been garbage collected");
        }
        AttributeList list = new AttributeList(this.beanAttributeInfo.length);
        for (String a : attributes) {
            Object result = ConfigContext.getAttributeFromContext(a, config);
            if (result instanceof EncryptionAuthenticationMode) {
                result = Objects.toString(result);
            }
            Attribute attribute = new Attribute(a, result);
            list.add(attribute);
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (!this.isSettable) {
            throw new UnsupportedOperationException("Can't set attributes for non-settable context");
        }
        AttributeList setList = new AttributeList(this.beanAttributeInfo.length);
        for (Attribute a : attributes.asList()) {
            try {
                this.setAttribute(a);
                setList.add(a);
            }
            catch (Exception e) {
                String msg = String.format("Can't modify attribute %s", a.getName());
                LOGGER.warn(msg, (Throwable)e);
            }
        }
        return setList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }
}

