/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.client.MantaMBeanable;
import com.joyent.manta.client.crypto.SupportedCiphersLookupMap;
import com.joyent.manta.config.ConfigContextMBean;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.exception.ConfigurationException;
import com.joyent.manta.util.MantaUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.management.DynamicMBean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public interface ConfigContext
extends MantaMBeanable {
    public String getMantaURL();

    public String getMantaUser();

    public String getMantaKeyId();

    public String getMantaKeyPath();

    public String getPrivateKeyContent();

    public String getPassword();

    public Integer getTimeout();

    default public String getMantaHomeDirectory() {
        return ConfigContext.deriveHomeDirectoryFromUser(this.getMantaUser());
    }

    public Integer getRetries();

    public Integer getMaximumConnections();

    public Integer getHttpBufferSize();

    public String getHttpsProtocols();

    public String getHttpsCipherSuites();

    public Boolean noAuth();

    public Boolean disableNativeSignatures();

    public Integer getTcpSocketTimeout();

    public Integer getConnectionRequestTimeout();

    public Integer getExpectContinueTimeout();

    public Boolean verifyUploads();

    public Integer getUploadBufferSize();

    public Integer getSkipDirectoryDepth();

    public Boolean isClientEncryptionEnabled();

    public Boolean permitUnencryptedDownloads();

    public EncryptionAuthenticationMode getEncryptionAuthenticationMode();

    public String getEncryptionKeyId();

    public String getEncryptionAlgorithm();

    public String getEncryptionPrivateKeyPath();

    public byte[] getEncryptionPrivateKeyBytes();

    @Override
    default public DynamicMBean toMBean() {
        return new ConfigContextMBean(this);
    }

    public static String deriveHomeDirectoryFromUser(String mantaUser) {
        if (mantaUser == null) {
            return null;
        }
        String[] accountParts = MantaUtils.parseAccount(mantaUser);
        return String.format("/%s", accountParts[0]);
    }

    public static String toString(ConfigContext context) {
        StringBuilder sb = new StringBuilder("BaseChainedConfigContext{");
        sb.append("mantaURL='").append(context.getMantaURL()).append('\'');
        sb.append(", user='").append(context.getMantaUser()).append('\'');
        sb.append(", mantaKeyId='").append(context.getMantaKeyId()).append('\'');
        sb.append(", mantaKeyPath='").append(context.getMantaKeyPath()).append('\'');
        sb.append(", timeout=").append(context.getTimeout());
        sb.append(", retries=").append(context.getRetries());
        sb.append(", maxConnections=").append(context.getMaximumConnections());
        sb.append(", httpBufferSize='").append(context.getHttpBufferSize()).append('\'');
        sb.append(", httpsProtocols='").append(context.getHttpsProtocols()).append('\'');
        sb.append(", httpsCiphers='").append(context.getHttpsCipherSuites()).append('\'');
        sb.append(", noAuth=").append(context.noAuth());
        sb.append(", disableNativeSignatures=").append(context.disableNativeSignatures());
        sb.append(", tcpSocketTimeout=").append(context.getTcpSocketTimeout());
        sb.append(", connectionRequestTimeout=").append(context.getConnectionRequestTimeout());
        sb.append(", verifyUploads=").append(context.verifyUploads());
        sb.append(", uploadBufferSize=").append(context.getUploadBufferSize());
        sb.append(", skipDirectoryDepth=").append(context.getSkipDirectoryDepth());
        sb.append(", clientEncryptionEnabled=").append(context.isClientEncryptionEnabled());
        sb.append(", permitUnencryptedDownloads=").append(context.permitUnencryptedDownloads());
        sb.append(", encryptionAuthenticationMode=").append((Object)context.getEncryptionAuthenticationMode());
        sb.append(", encryptionKeyId=").append(context.getEncryptionKeyId());
        sb.append(", encryptionAlgorithm=").append(context.getEncryptionAlgorithm());
        sb.append(", encryptionPrivateKeyPath=").append(context.getEncryptionPrivateKeyPath());
        if (context.getEncryptionPrivateKeyBytes() == null) {
            sb.append(", encryptionPrivateKeyBytesLength=").append("null object");
        } else {
            sb.append(", encryptionPrivateKeyBytesLength=").append(context.getEncryptionPrivateKeyBytes().length);
        }
        sb.append('}');
        return sb.toString();
    }

    public static void validate(ConfigContext config) {
        boolean authenticationEnabled;
        ArrayList<String> failureMessages = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)config.getMantaUser())) {
            failureMessages.add("Manta account name must be specified");
        }
        if (StringUtils.isBlank((CharSequence)config.getMantaURL())) {
            failureMessages.add("Manta URL must be specified");
        } else {
            try {
                new URI(config.getMantaURL());
            }
            catch (URISyntaxException e) {
                String msg = String.format("%s - invalid Manta URL: %s", e.getMessage(), config.getMantaURL());
                failureMessages.add(msg);
            }
        }
        if (config.getTimeout() != null && config.getTimeout() < 0) {
            failureMessages.add("Manta timeout must be 0 or greater");
        }
        if (config.getTcpSocketTimeout() != null && config.getTcpSocketTimeout() < 0) {
            failureMessages.add("Manta tcp socket timeout must be 0 or greater");
        }
        if (config.getConnectionRequestTimeout() != null && config.getConnectionRequestTimeout() < 0) {
            failureMessages.add("Manta connection request timeout must be 0 or greater");
        }
        if (config.getExpectContinueTimeout() != null && config.getExpectContinueTimeout() < 1) {
            failureMessages.add("Manta Expect 100-continue timeout must be 1 or greater");
        }
        if (authenticationEnabled = BooleanUtils.isNotTrue((Boolean)config.noAuth())) {
            if (config.getMantaKeyId() == null) {
                failureMessages.add("Manta key id must be specified");
            }
            if (config.getMantaKeyPath() == null && config.getPrivateKeyContent() == null) {
                failureMessages.add("Either the Manta key path must be set or the private key content must be set. Both can't be null.");
            }
            if (config.getMantaKeyPath() != null && StringUtils.isBlank((CharSequence)config.getMantaKeyPath())) {
                failureMessages.add("Manta key path must not be blank");
            }
            if (config.getPrivateKeyContent() != null && StringUtils.isBlank((CharSequence)config.getPrivateKeyContent())) {
                failureMessages.add("Manta private key content must not be blank");
            }
        }
        if (config.getSkipDirectoryDepth() != null && config.getSkipDirectoryDepth() < 0) {
            failureMessages.add("Manta skip directory depth must be 0 or greater");
        }
        if (BooleanUtils.isTrue((Boolean)config.isClientEncryptionEnabled())) {
            ConfigContext.encryptionSettings(config, failureMessages);
        }
        if (!failureMessages.isEmpty()) {
            String messages = StringUtils.join(failureMessages, (String)System.lineSeparator());
            ConfigurationException e = new ConfigurationException("Errors when loading Manta SDK configuration:" + System.lineSeparator() + messages);
            e.setContextValue("manta.url", config.getMantaURL());
            e.setContextValue("manta.user", config.getMantaUser());
            e.setContextValue("manta.key_id", config.getMantaKeyId());
            e.setContextValue("manta.no_auth", config.noAuth());
            e.setContextValue("manta.key_path", config.getMantaKeyPath());
            String redactedPrivateKeyContent = config.getPrivateKeyContent() == null ? "null" : "non-null";
            e.setContextValue("manta.key_content", redactedPrivateKeyContent);
            e.setContextValue("manta.client_encryption", config.isClientEncryptionEnabled());
            if (BooleanUtils.isTrue((Boolean)config.isClientEncryptionEnabled())) {
                e.setContextValue("manta.encryption_key_id", config.getEncryptionKeyId());
                e.setContextValue("manta.permit_unencrypted_downloads", config.permitUnencryptedDownloads());
                e.setContextValue("manta.encryption_algorithm", config.getEncryptionAlgorithm());
                e.setContextValue("manta.encryption_key_path", config.getEncryptionPrivateKeyPath());
                e.setContextValue("manta.encryption_key_bytes_size", ArrayUtils.getLength((Object)config.getEncryptionPrivateKeyBytes()));
            }
            throw e;
        }
    }

    public static void encryptionSettings(ConfigContext config, List<String> failureMessages) {
        String algorithm;
        if (config.getEncryptionKeyId() == null) {
            failureMessages.add("Encryption key id must not be null");
        }
        if (config.getEncryptionKeyId() != null && StringUtils.isEmpty((CharSequence)config.getEncryptionKeyId())) {
            failureMessages.add("Encryption key id must not be empty");
        }
        if (config.getEncryptionKeyId() != null && StringUtils.containsWhitespace((CharSequence)config.getEncryptionKeyId())) {
            failureMessages.add("Encryption key id must not contain whitespace");
        }
        if (config.getEncryptionKeyId() != null && !StringUtils.isAsciiPrintable((CharSequence)config.getEncryptionKeyId())) {
            failureMessages.add("Encryption key id must only contain printable ASCII characters");
        }
        if (config.getEncryptionAuthenticationMode() == null) {
            failureMessages.add("Encryption authentication mode must not be null");
        }
        if (config.permitUnencryptedDownloads() == null) {
            failureMessages.add("Permit unencrypted downloads flag must not be null");
        }
        if (config.getEncryptionPrivateKeyPath() == null && config.getEncryptionPrivateKeyBytes() == null) {
            failureMessages.add("Both encryption private key path and private key bytes must not be null");
        }
        if (config.getEncryptionPrivateKeyPath() != null && config.getEncryptionPrivateKeyBytes() != null) {
            failureMessages.add("Both encryption private key path and private key bytes must not be set. Choose one or the other.");
        }
        if (config.getEncryptionPrivateKeyPath() != null) {
            File keyFile = new File(config.getEncryptionPrivateKeyPath());
            if (!keyFile.exists()) {
                failureMessages.add(String.format("Key file couldn't be found at path: %s", config.getEncryptionPrivateKeyPath()));
            } else if (!keyFile.canRead()) {
                failureMessages.add(String.format("Key file couldn't be read at path: %s", config.getEncryptionPrivateKeyPath()));
            }
        }
        if (config.getEncryptionPrivateKeyBytes() != null && config.getEncryptionPrivateKeyBytes().length == 0) {
            failureMessages.add("Encryption private key byte length must be greater than zero");
        }
        if ((algorithm = config.getEncryptionAlgorithm()) == null) {
            failureMessages.add("Encryption algorithm must not be null");
        }
        if (algorithm != null && StringUtils.isBlank((CharSequence)algorithm)) {
            failureMessages.add("Encryption algorithm must not be blank");
        }
        if (algorithm != null && !SupportedCiphersLookupMap.INSTANCE.containsKeyCaseInsensitive(algorithm)) {
            String availableAlgorithms = StringUtils.join(SupportedCiphersLookupMap.INSTANCE.keySet(), (String)", ");
            failureMessages.add(String.format("Cipher algorithm [%s] was not found among the list of supported algorithms [%s]", algorithm, availableAlgorithms));
        }
    }

    public static Object getAttributeFromContext(String attribute, ConfigContext config) {
        switch (attribute) {
            case "manta.url": 
            case "MANTA_URL": {
                return config.getMantaURL();
            }
            case "manta.user": 
            case "MANTA_USER": {
                return config.getMantaUser();
            }
            case "manta.key_id": 
            case "MANTA_KEY_ID": {
                return config.getMantaKeyId();
            }
            case "manta.key_path": 
            case "MANTA_KEY_PATH": {
                return config.getMantaKeyPath();
            }
            case "manta.timeout": 
            case "MANTA_TIMEOUT": {
                return config.getTimeout();
            }
            case "manta.retries": 
            case "MANTA_HTTP_RETRIES": {
                return config.getRetries();
            }
            case "manta.max_connections": 
            case "MANTA_MAX_CONNS": {
                return config.getMaximumConnections();
            }
            case "manta.key_content": 
            case "MANTA_KEY_CONTENT": {
                return config.getPrivateKeyContent();
            }
            case "manta.password": 
            case "MANTA_PASSWORD": {
                return config.getPassword();
            }
            case "manta.http_buffer_size": 
            case "MANTA_HTTP_BUFFER_SIZE": {
                return config.getHttpBufferSize();
            }
            case "https.protocols": 
            case "MANTA_HTTPS_PROTOCOLS": {
                return config.getHttpsProtocols();
            }
            case "https.cipherSuites": 
            case "MANTA_HTTPS_CIPHERS": {
                return config.getHttpsCipherSuites();
            }
            case "manta.no_auth": 
            case "MANTA_NO_AUTH": {
                return config.noAuth();
            }
            case "manta.disable_native_sigs": 
            case "MANTA_NO_NATIVE_SIGS": {
                return config.disableNativeSignatures();
            }
            case "manta.tcp_socket_timeout": 
            case "MANTA_TCP_SOCKET_TIMEOUT": {
                return config.getTcpSocketTimeout();
            }
            case "manta.connection_request_timeout": 
            case "MANTA_CONNECTION_REQUEST_TIMEOUT": {
                return config.getConnectionRequestTimeout();
            }
            case "manta.expect_continue_timeout": 
            case "MANTA_EXPECT_CONTINUE_TIMEOUT": {
                return config.getExpectContinueTimeout();
            }
            case "manta.client_encryption": 
            case "MANTA_CLIENT_ENCRYPTION": {
                return config.isClientEncryptionEnabled();
            }
            case "manta.verify_uploads": 
            case "MANTA_VERIFY_UPLOADS": {
                return config.verifyUploads();
            }
            case "manta.upload_buffer_size": 
            case "MANTA_UPLOAD_BUFFER_SIZE": {
                return config.getUploadBufferSize();
            }
            case "manta.skip_directory_depth": 
            case "MANTA_SKIP_DIRECTORY_DEPTH": {
                return config.getSkipDirectoryDepth();
            }
            case "manta.permit_unencrypted_downloads": 
            case "MANTA_UNENCRYPTED_DOWNLOADS": {
                return config.permitUnencryptedDownloads();
            }
            case "manta.encryption_key_id": 
            case "MANTA_CLIENT_ENCRYPTION_KEY_ID": {
                return config.getEncryptionKeyId();
            }
            case "manta.encryption_algorithm": 
            case "MANTA_ENCRYPTION_ALGORITHM": {
                return config.getEncryptionAlgorithm();
            }
            case "manta.encryption_auth_mode": 
            case "MANTA_ENCRYPTION_AUTH_MODE": {
                return config.getEncryptionAuthenticationMode();
            }
            case "manta.encryption_key_path": 
            case "MANTA_ENCRYPTION_KEY_PATH": {
                return config.getEncryptionPrivateKeyPath();
            }
            case "manta.encryption_key_bytes": {
                return config.getEncryptionPrivateKeyBytes();
            }
            case "manta.encryption_key_bytes_base64": 
            case "MANTA_ENCRYPTION_KEY_BYTES": {
                return Base64.getEncoder().encode(config.getEncryptionPrivateKeyBytes());
            }
        }
        return null;
    }
}

