/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.ObjectUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalSecurityProviderLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalSecurityProviderLoader.class);
    private static final String BC_PROVIDER_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String PKCS11_PROVIDER_NAME = "SunPKCS11-NSS";
    private static final Provider PKCS11_PROVIDER;
    private static final Provider BC_PROVIDER;

    private ExternalSecurityProviderLoader() {
    }

    public static Provider getPkcs11Provider() {
        return PKCS11_PROVIDER;
    }

    public static Provider getBouncyCastleProvider() {
        return BC_PROVIDER;
    }

    public static Provider getPreferredProvider() {
        return (Provider)ObjectUtils.firstNonNull((Object[])new Provider[]{PKCS11_PROVIDER, BC_PROVIDER});
    }

    static {
        Provider pkcs11Provider = Security.getProvider(PKCS11_PROVIDER_NAME);
        if (pkcs11Provider != null) {
            PKCS11_PROVIDER = pkcs11Provider;
            LOGGER.debug("PKCS11 NSS provider was loaded - native crypto support enabled");
        } else {
            PKCS11_PROVIDER = null;
        }
        Provider bouncyCastleProvider = Security.getProvider(BC_PROVIDER_NAME);
        if (bouncyCastleProvider == null) {
            BC_PROVIDER = new BouncyCastleProvider();
            Security.addProvider(BC_PROVIDER);
            LOGGER.debug("Bouncy Castle provider was not loaded, adding to providers");
        } else {
            BC_PROVIDER = bouncyCastleProvider;
        }
    }
}

