/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.vault.VaultCredentials;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class TripleCryptKeyPair {
    private static final Logger log = Logger.getLogger(TripleCryptKeyPair.class);
    private final HostPasswordStore keychain = PasswordStoreFactory.get();

    public Credentials unlock(PasswordCallback callback, Host bookmark, UserKeyPair keypair) throws CryptoException, LoginCanceledException {
        String passphrase = this.keychain.getPassword(String.format("Triple-Crypt Encryption Password (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory))).find(DescriptiveUrl.Type.provider).getUrl());
        return this.unlock(callback, bookmark, keypair, passphrase, LocaleFactory.localizedString((String)"Enter your decryption password to access encrypted data rooms.", (String)"SDS"));
    }

    private Credentials unlock(PasswordCallback callback, Host bookmark, UserKeyPair keypair, String passphrase, String message) throws LoginCanceledException, CryptoException {
        VaultCredentials credentials;
        if (null == passphrase) {
            credentials = callback.prompt(bookmark, LocaleFactory.localizedString((String)"Decryption password required", (String)"SDS"), message, new LoginOptions(bookmark.getProtocol()).user(false).password(true).anonymous(false).icon(bookmark.getProtocol().disk()));
            if (credentials.getPassword() == null) {
                throw new LoginCanceledException();
            }
        } else {
            credentials = new VaultCredentials(passphrase).withSaved(true);
        }
        if (!Crypto.checkUserKeyPair((UserKeyPair)keypair, (String)credentials.getPassword())) {
            return this.unlock(callback, bookmark, keypair, null, String.format("%s. %s", LocaleFactory.localizedString((String)"Invalid passphrase", (String)"Credentials"), LocaleFactory.localizedString((String)"Enter your decryption password to access encrypted data rooms.", (String)"SDS")));
        }
        if (credentials.isSaved()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Save encryption password for %s", bookmark));
            }
            this.keychain.addPassword(String.format("Triple-Crypt Encryption Password (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory))).find(DescriptiveUrl.Type.provider).getUrl(), credentials.getPassword());
        }
        return credentials;
    }
}

