/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.list;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ftp.DataConnectionAction;
import ch.cyberduck.core.ftp.DataConnectionActionExecutor;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.ftp.list.FTPDataResponseReader;
import ch.cyberduck.core.ftp.list.FTPListResponseReader;
import ch.cyberduck.core.ftp.list.FTPListService;
import ch.cyberduck.core.ftp.parser.CompositeFileEntryParser;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPFileEntryParser;

public class FTPDefaultListService
implements ListService {
    private final FTPSession session;
    private final FTPListService.Command command;
    private final FTPDataResponseReader reader;
    private final HostPasswordStore keychain;
    private final LoginCallback prompt;

    public FTPDefaultListService(FTPSession session, HostPasswordStore keychain, LoginCallback prompt, CompositeFileEntryParser parser, FTPListService.Command command) {
        this.session = session;
        this.keychain = keychain;
        this.prompt = prompt;
        this.command = command;
        this.reader = new FTPListResponseReader((FTPFileEntryParser)parser, false);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            if (!((FTPClient)((Object)this.session.getClient())).changeWorkingDirectory(directory.getAbsolute())) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
            if (!((FTPClient)((Object)this.session.getClient())).setFileType(0)) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
            List<String> list = new DataConnectionActionExecutor(this.session).data(new DataConnectionAction<List<String>>(){

                @Override
                public List<String> execute() throws BackgroundException {
                    try {
                        return ((FTPClient)((Object)FTPDefaultListService.this.session.getClient())).list(FTPDefaultListService.this.command.getCommand(), FTPDefaultListService.this.command.getArg());
                    }
                    catch (IOException e) {
                        throw new FTPExceptionMappingService().map(e);
                    }
                }
            }, (ProgressListener)listener);
            return this.reader.read(directory, list, listener);
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

