/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class ThreadPoolFactory
extends Factory<ThreadPool> {
    private static final Logger log = Logger.getLogger(ThreadPoolFactory.class);

    public ThreadPoolFactory() {
        super("factory.threadpool.class");
    }

    protected ThreadPool create(String prefix, Integer size, Thread.UncaughtExceptionHandler handler) {
        String clazz = PreferencesFactory.get().getProperty("factory.threadpool.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{prefix.getClass(), size.getClass(), handler.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", handler.getClass()));
                return (ThreadPool)name.newInstance();
            }
            return (ThreadPool)constructor.newInstance(prefix, size, handler);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static ThreadPool get() {
        return ThreadPoolFactory.get(new LoggingUncaughtExceptionHandler());
    }

    public static ThreadPool get(Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get("background", PreferencesFactory.get().getInteger("threading.pool.size.max"), handler);
    }

    public static ThreadPool get(String prefix, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get(prefix, PreferencesFactory.get().getInteger("threading.pool.size.max"), handler);
    }

    public static ThreadPool get(int size) {
        return ThreadPoolFactory.get("background", size);
    }

    public static ThreadPool get(int size, Thread.UncaughtExceptionHandler handler) {
        return ThreadPoolFactory.get("background", size, handler);
    }

    public static ThreadPool get(String prefix, int size) {
        return ThreadPoolFactory.get(prefix, size, new LoggingUncaughtExceptionHandler());
    }

    public static ThreadPool get(String prefix, int size, Thread.UncaughtExceptionHandler handler) {
        return new ThreadPoolFactory().create(prefix, size, handler);
    }
}

