/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.HostDictionary;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.serializer.TransferItemDictionary;
import ch.cyberduck.core.transfer.CopyTransfer;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.SyncTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.UploadTransfer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class TransferDictionary {
    private static final Logger log = Logger.getLogger(TransferDictionary.class);
    private final DeserializerFactory deserializer;
    private final ProtocolFactory protocols;

    public TransferDictionary() {
        this(ProtocolFactory.get());
    }

    public TransferDictionary(ProtocolFactory protocols) {
        this(protocols, new DeserializerFactory());
    }

    public TransferDictionary(DeserializerFactory deserializer) {
        this(ProtocolFactory.get(), deserializer);
    }

    public TransferDictionary(ProtocolFactory protocols, DeserializerFactory deserializer) {
        this.protocols = protocols;
        this.deserializer = deserializer;
    }

    public <T> Transfer deserialize(T serialized) {
        String bandwidthObj;
        String currentObj;
        String timestampObj;
        String sizeObj;
        Transfer transfer;
        String typeObj;
        List rootsObj;
        Deserializer dict = this.deserializer.create(serialized);
        Object hostObj = dict.objectForKey("Host");
        if (null == hostObj) {
            log.warn((Object)"Missing host in transfer");
            return null;
        }
        Host host = new HostDictionary(this.protocols, this.deserializer).deserialize(hostObj);
        if (null == host) {
            log.warn((Object)"Invalid host in transfer");
            return null;
        }
        List itemsObj = dict.listForKey("Items");
        ArrayList<TransferItem> roots = new ArrayList<TransferItem>();
        if (itemsObj != null) {
            for (Object rootDict : itemsObj) {
                TransferItem item = new TransferItemDictionary(this.deserializer).deserialize(rootDict);
                if (null == item) {
                    log.warn((Object)"Invalid item in transfer");
                    continue;
                }
                roots.add(item);
            }
        }
        if ((rootsObj = dict.listForKey("Roots")) != null) {
            for (Object rootDict : rootsObj) {
                Object localObj;
                Path remote = new PathDictionary(this.deserializer).deserialize(rootDict);
                if (null == remote) {
                    log.warn((Object)"Invalid remote in transfer");
                    continue;
                }
                TransferItem item = new TransferItem(remote);
                String localObjDeprecated = this.deserializer.create(rootDict).stringForKey("Local");
                if (localObjDeprecated != null) {
                    Local local = LocalFactory.get(localObjDeprecated);
                    item.setLocal(local);
                }
                if ((localObj = this.deserializer.create(rootDict).objectForKey("Local Dictionary")) != null) {
                    Local local = new LocalDictionary(this.deserializer).deserialize(localObj);
                    if (null == local) {
                        log.warn((Object)"Invalid local in transfer item");
                        continue;
                    }
                    item.setLocal(local);
                }
                roots.add(item);
            }
        }
        if (roots.isEmpty()) {
            log.warn((Object)"No files in transfer");
            return null;
        }
        Transfer.Type type = null;
        String kindObj = dict.stringForKey("Kind");
        if (kindObj != null) {
            type = Transfer.Type.values()[Integer.parseInt(kindObj)];
        }
        if ((typeObj = dict.stringForKey("Type")) != null) {
            type = Transfer.Type.valueOf(typeObj);
        }
        if (null == type) {
            log.warn((Object)"Missing transfer type");
            return null;
        }
        switch (type) {
            case download: 
            case upload: 
            case sync: {
                for (TransferItem item : roots) {
                    if (null == item.remote) {
                        log.warn((Object)String.format("Missing remote in transfer item %s", item));
                        return null;
                    }
                    if (null != item.local) continue;
                    log.warn((Object)String.format("Missing local in transfer item %s", item));
                    return null;
                }
                break;
            }
        }
        switch (type) {
            case download: {
                transfer = new DownloadTransfer(host, roots);
                break;
            }
            case upload: {
                transfer = new UploadTransfer(host, roots);
                break;
            }
            case sync: {
                String actionObj = dict.stringForKey("Action");
                if (null == actionObj) {
                    transfer = new SyncTransfer(host, (TransferItem)roots.iterator().next());
                    break;
                }
                transfer = new SyncTransfer(host, (TransferItem)roots.iterator().next(), TransferAction.forName(actionObj));
                break;
            }
            case copy: {
                Object destinationObj = dict.objectForKey("Destination");
                if (null == destinationObj) {
                    log.warn((Object)"Missing destination for copy transfer");
                    return null;
                }
                List destinations = dict.listForKey("Destinations");
                if (destinations.isEmpty()) {
                    log.warn((Object)"No destinations in copy transfer");
                    return null;
                }
                if (roots.size() == destinations.size()) {
                    HashMap<Path, Path> files = new HashMap<Path, Path>();
                    for (int i = 0; i < roots.size(); ++i) {
                        Path target = new PathDictionary(this.deserializer).deserialize(destinations.get(i));
                        if (null == target) continue;
                        files.put(((TransferItem)roots.get((int)i)).remote, target);
                    }
                    Host target = new HostDictionary(this.protocols, this.deserializer).deserialize(destinationObj);
                    if (null == target) {
                        log.warn((Object)"Missing target host in copy transfer");
                        return null;
                    }
                    transfer = new CopyTransfer(host, target, files);
                    break;
                }
                log.warn((Object)"Invalid file mapping for copy transfer");
                return null;
            }
            default: {
                log.warn((Object)String.format("Unknown transfer type %s", kindObj));
                return null;
            }
        }
        String uuidObj = dict.stringForKey("UUID");
        if (uuidObj != null) {
            transfer.setUuid(uuidObj.toString());
        }
        if ((sizeObj = dict.stringForKey("Size")) != null) {
            transfer.setSize((long)Double.parseDouble(sizeObj.toString()));
        }
        if ((timestampObj = dict.stringForKey("Timestamp")) != null) {
            transfer.setTimestamp(new Date(Long.parseLong(timestampObj.toString())));
        }
        if ((currentObj = dict.stringForKey("Current")) != null) {
            transfer.setTransferred((long)Double.parseDouble(currentObj.toString()));
        }
        if ((bandwidthObj = dict.stringForKey("Bandwidth")) != null) {
            transfer.getBandwidth().setRate(Float.parseFloat(bandwidthObj.toString()));
        }
        return transfer;
    }
}

