/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.DisabledCertificateStore;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLocale;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.DisabledSleepPreventer;
import ch.cyberduck.core.DisabledTerminalService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PreferencesProxyCredentialsStore;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.aquaticprime.DonationKeyFactory;
import ch.cyberduck.core.date.DefaultUserDateFormatter;
import ch.cyberduck.core.diagnostics.DefaultInetAddressReachability;
import ch.cyberduck.core.formatter.DecimalSizeFormatter;
import ch.cyberduck.core.i18n.Locales;
import ch.cyberduck.core.io.watchservice.NIOEventWatchService;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.DefaultTemporaryFileService;
import ch.cyberduck.core.local.DefaultWorkingDirectoryFinder;
import ch.cyberduck.core.local.DisabledApplicationBadgeLabeler;
import ch.cyberduck.core.local.DisabledApplicationFinder;
import ch.cyberduck.core.local.DisabledApplicationLauncher;
import ch.cyberduck.core.local.DisabledBrowserLauncher;
import ch.cyberduck.core.local.DisabledFilesystemBookmarkResolver;
import ch.cyberduck.core.local.DisabledIconService;
import ch.cyberduck.core.local.DisabledQuarantineService;
import ch.cyberduck.core.local.NativeLocalTrashFeature;
import ch.cyberduck.core.local.NullFileDescriptor;
import ch.cyberduck.core.local.NullLocalSymlinkFeature;
import ch.cyberduck.core.notification.DisabledNotificationService;
import ch.cyberduck.core.preferences.TemporaryApplicationResourcesFinder;
import ch.cyberduck.core.preferences.TemporarySupportDirectoryFinder;
import ch.cyberduck.core.proxy.DisabledProxyFinder;
import ch.cyberduck.core.random.DefaultSecureRandomProvider;
import ch.cyberduck.core.resources.DisabledIconCache;
import ch.cyberduck.core.serializer.impl.dd.HostPlistReader;
import ch.cyberduck.core.serializer.impl.dd.PlistDeserializer;
import ch.cyberduck.core.serializer.impl.dd.PlistSerializer;
import ch.cyberduck.core.serializer.impl.dd.PlistWriter;
import ch.cyberduck.core.serializer.impl.dd.ProfilePlistReader;
import ch.cyberduck.core.serializer.impl.dd.TransferPlistReader;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.DisabledActionOperationBatcher;
import ch.cyberduck.core.threading.DisabledAlertCallback;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.updater.DisabledPeriodicUpdater;
import ch.cyberduck.core.urlhandler.DisabledSchemeHandler;
import ch.cyberduck.core.vault.DisabledVault;
import ch.cyberduck.core.webloc.InternetShortcutFileWriter;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class Preferences
implements Locales {
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(Preferences.class);
    protected static final String LIST_SEPERATOR = " ";

    protected void post() {
        if (this.getBoolean("connection.dns.ipv6")) {
            System.setProperty("java.net.preferIPv6Addresses", String.valueOf(true));
        }
        Security.setProperty("networkaddress.cache.ttl", "10");
        Security.setProperty("networkaddress.cache.negative.ttl", "5");
        int position = this.getInteger("connection.ssl.provider.bouncycastle.position");
        BouncyCastleProvider provider = new BouncyCastleProvider();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Install provider %s at position %d", provider, position));
        }
        Security.insertProviderAt((Provider)provider, position);
    }

    public abstract void setProperty(String var1, String var2);

    public void setProperty(String property, List<String> values) {
        this.setProperty(property, StringUtils.join(values, (String)LIST_SEPERATOR));
    }

    public abstract void deleteProperty(String var1);

    public void setProperty(String property, boolean v) {
        this.setProperty(property, v ? String.valueOf(true) : String.valueOf(false));
    }

    public void setProperty(String property, int v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, float v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, long v) {
        this.setProperty(property, String.valueOf(v));
    }

    public void setProperty(String property, double v) {
        this.setProperty(property, String.valueOf(v));
    }

    public abstract String getDefault(String var1);

    public abstract void setDefault(String var1, String var2);

    protected void setDefaults(Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.setDefault(property.getKey().toString(), property.getValue().toString());
        }
    }

    protected void setDefaults() {
        this.setDefault("application.version", Version.getSpecification());
        this.setDefault("application.revision", Version.getImplementation());
        this.setDefault("tmp.dir", System.getProperty("java.io.tmpdir"));
        this.setDefault("uses", "0");
        this.setDefault("donate.reminder", String.valueOf(-1));
        this.setDefault("donate.reminder.interval", String.valueOf(20));
        this.setDefault("donate.reminder.date", String.valueOf(new Date(0L).getTime()));
        this.setDefault("defaulthandler.reminder", String.valueOf(true));
        this.setDefault("mail.feedback", "mailto:support@cyberduck.io");
        this.setDefault("website.donate", "https://cyberduck.io/donate/");
        this.setDefault("website.home", "https://cyberduck.io/");
        this.setDefault("website.help", "https://help.cyberduck.io/" + this.locale());
        this.setDefault("website.bug", "https://trac.cyberduck.io/newticket?version={0}");
        this.setDefault("website.crash", "https://crash.cyberduck.io/report");
        this.setDefault("website.cli", "https://duck.sh/");
        this.setDefault("website.license", "https://cyberduck.io/license");
        this.setDefault("website.acknowledgments", "https://cyberduck.io/acknowledgments");
        this.setDefault("rendezvous.enable", String.valueOf(true));
        this.setDefault("rendezvous.loopback.suppress", String.valueOf(true));
        this.setDefault("rendezvous.notification.limit", String.valueOf(0));
        this.setDefault("growl.enable", String.valueOf(true));
        this.setDefault("path.symboliclink.resolve", String.valueOf(false));
        this.setDefault("path.normalize", String.valueOf(true));
        this.setDefault("path.normalize.unicode", String.valueOf(false));
        this.setDefault("local.user.home", System.getProperty("user.home"));
        this.setDefault("local.alias.resolve", String.valueOf(true));
        this.setDefault("local.symboliclink.resolve", String.valueOf(false));
        this.setDefault("local.normalize.prefix", String.valueOf(false));
        this.setDefault("local.normalize.unicode", String.valueOf(true));
        this.setDefault("local.normalize.tilde", String.valueOf(true));
        this.setDefault("local.delimiter", File.separator);
        this.setDefault("local.temporaryfiles.shortening.threshold", String.valueOf(240));
        this.setDefault("application.name", "Cyberduck");
        this.setDefault("application.container.name", "duck");
        this.setDefault("bookmarks.folder.name", "Bookmarks");
        this.setDefault("profiles.folder.name", "Profiles");
        this.setDefault("browser.cache.size", String.valueOf(1000));
        this.setDefault("transfer.cache.size", String.valueOf(100));
        this.setDefault("icon.cache.size", String.valueOf(200));
        this.setDefault("preferences.cache.size", String.valueOf(1000));
        this.setDefault("browser.model.cache.size", String.valueOf(10000));
        this.setDefault("browser.list.limit.directory", String.valueOf(5000));
        this.setDefault("browser.list.limit.container", String.valueOf(100));
        this.setDefault("info.toolbar.selected", String.valueOf(0));
        this.setDefault("preferences.toolbar.selected", String.valueOf(0));
        this.setDefault("browser.view", "1");
        this.setDefault("browser.serialize", String.valueOf(true));
        this.setDefault("browser.font.size", String.valueOf(12.0f));
        this.setDefault("browser.view.autoexpand", String.valueOf(true));
        this.setDefault("browser.view.autoexpand.useDelay", String.valueOf(true));
        this.setDefault("browser.view.autoexpand.delay", "1.0");
        this.setDefault("browser.hidden.regex", "\\..*");
        this.setDefault("browser.open.untitled", String.valueOf(true));
        this.setDefault("browser.open.bookmark.default", null);
        this.setDefault("browser.disconnect.confirm", String.valueOf(false));
        this.setDefault("browser.disconnect.bookmarks.show", String.valueOf(false));
        this.setDefault("browser.info.inspector", String.valueOf(true));
        this.setDefault("browser.sort.ascending", String.valueOf(true));
        this.setDefault("browser.alternatingRows", String.valueOf(false));
        this.setDefault("browser.verticalLines", String.valueOf(false));
        this.setDefault("browser.horizontalLines", String.valueOf(true));
        this.setDefault("browser.showHidden", String.valueOf(false));
        this.setDefault("browser.charset.encoding", "UTF-8");
        this.setDefault("browser.doubleclick.edit", String.valueOf(false));
        this.setDefault("browser.enterkey.rename", String.valueOf(true));
        this.setDefault("browser.editable", String.valueOf(true));
        this.setDefault("browser.move.confirm", String.valueOf(true));
        this.setDefault("browser.copy.confirm", String.valueOf(false));
        this.setDefault("browser.transcript.open", String.valueOf(false));
        this.setDefault("browser.transcript.size.height", String.valueOf(200));
        this.setDefault("browser.duplicate.format", "{0} ({1}){2}");
        this.setDefault("browser.filesize.decimal", String.valueOf(false));
        this.setDefault("browser.date.natural", String.valueOf(true));
        this.setDefault("browser.delete.concurrency", String.valueOf(10));
        this.setDefault("info.toggle.permission", String.valueOf(1));
        this.setDefault("info.toggle.distribution", String.valueOf(0));
        this.setDefault("info.toggle.s3", String.valueOf(0));
        this.setDefault("connection.toggle.options", String.valueOf(0));
        this.setDefault("bookmark.toggle.options", String.valueOf(0));
        this.setDefault("alert.toggle.transcript", String.valueOf(0));
        this.setDefault("transfer.toggle.details", String.valueOf(1));
        this.setDefault("editor.bundleIdentifier", "com.apple.TextEdit");
        this.setDefault("editor.alwaysUseDefault", String.valueOf(false));
        this.setDefault("editor.upload.permissions.change", String.valueOf(true));
        this.setDefault("editor.upload.symboliclink.resolve", String.valueOf(true));
        this.setDefault("favorites.save", String.valueOf(true));
        this.setDefault("queue.removeItemWhenComplete", String.valueOf(false));
        this.setDefault("queue.transfer.type.enabled", String.format("%s %s %s", String.valueOf(Host.TransferType.browser.name()), String.valueOf(Host.TransferType.newconnection.name()), String.valueOf(Host.TransferType.concurrent.name())));
        this.setDefault("queue.transfer.type", String.valueOf(Host.TransferType.concurrent.name()));
        this.setDefault("queue.size.warn", String.valueOf(20));
        this.setDefault("queue.window.open.default", String.valueOf(false));
        this.setDefault("queue.window.open.transfer.start", String.valueOf(true));
        this.setDefault("queue.window.open.transfer.stop", String.valueOf(false));
        this.setDefault("queue.download.action", TransferAction.callback.name());
        this.setDefault("queue.upload.action", TransferAction.callback.name());
        this.setDefault("queue.copy.action", TransferAction.callback.name());
        this.setDefault("queue.download.reload.action", TransferAction.callback.name());
        this.setDefault("queue.upload.reload.action", TransferAction.callback.name());
        this.setDefault("queue.copy.reload.action", TransferAction.callback.name());
        this.setDefault("queue.upload.permissions.change", String.valueOf(false));
        this.setDefault("queue.upload.permissions.default", String.valueOf(false));
        this.setDefault("queue.upload.permissions.file.default", String.valueOf(644));
        this.setDefault("queue.upload.permissions.folder.default", String.valueOf(755));
        this.setDefault("queue.upload.timestamp.change", String.valueOf(false));
        this.setDefault("queue.upload.file.metadata.change", String.valueOf(true));
        this.setDefault("queue.upload.file.encryption.change", String.valueOf(true));
        this.setDefault("queue.upload.file.redundancy.change", String.valueOf(true));
        this.setDefault("queue.upload.checksum.calculate", String.valueOf(true));
        this.setDefault("queue.upload.skip.enable", String.valueOf(true));
        this.setDefault("queue.upload.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS");
        this.setDefault("queue.upload.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS");
        this.setDefault("queue.upload.priority.regex", "");
        this.setDefault("queue.upload.file.temporary", String.valueOf(false));
        this.setDefault("queue.upload.file.temporary.format", "{0}-{1}");
        this.setDefault("queue.upload.file.rename.format", "{0} ({1}){2}");
        this.setDefault("queue.download.file.rename.format", "{0} ({1}){2}");
        this.setDefault("queue.download.permissions.change", String.valueOf(true));
        this.setDefault("queue.download.permissions.default", String.valueOf(false));
        this.setDefault("queue.download.permissions.file.default", String.valueOf(644));
        this.setDefault("queue.download.permissions.folder.default", String.valueOf(755));
        this.setDefault("queue.download.timestamp.change", String.valueOf(true));
        this.setDefault("queue.download.checksum", String.valueOf(true));
        this.setDefault("queue.download.skip.enable", String.valueOf(true));
        this.setDefault("queue.download.skip.regex.default", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs|\\.file-segments");
        this.setDefault("queue.download.skip.regex", ".*~\\..*|\\.DS_Store|\\.svn|CVS|RCS|SCCS|\\.git|\\.bzr|\\.bzrignore|\\.bzrtags|\\.hg|\\.hgignore|\\.hgtags|_darcs|\\.file-segments");
        this.setDefault("queue.download.priority.regex", "");
        this.setDefault("queue.download.folder", System.getProperty("user.dir"));
        this.setDefault("queue.download.folder.bookmark", null);
        this.setDefault("queue.download.quarantine", String.valueOf(true));
        this.setDefault("queue.download.wherefrom", String.valueOf(true));
        this.setDefault("queue.download.segments", String.valueOf(false));
        this.setDefault("queue.download.segments.threshold", String.valueOf(0x6400000L));
        this.setDefault("queue.download.segments.size", String.valueOf(0x3200000L));
        this.setDefault("queue.download.complete.open", String.valueOf(false));
        this.setDefault("queue.dock.badge", String.valueOf(false));
        this.setDefault("queue.sleep.prevent", String.valueOf(true));
        StringBuilder options = new StringBuilder();
        options.append(5L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(10L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(20L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(50L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(100L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(150L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(200L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(500L * DecimalSizeFormatter.KILO.multiple()).append(",");
        options.append(1L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(2L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(5L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(10L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(15L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(20L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(50L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        options.append(100L * DecimalSizeFormatter.MEGA.multiple()).append(",");
        this.setDefault("queue.bandwidth.options", options.toString());
        this.setDefault("queue.upload.bandwidth.bytes", String.valueOf(-1));
        this.setDefault("queue.download.bandwidth.bytes", String.valueOf(-1));
        this.setDefault("queue.connections.limit", String.valueOf(2));
        options = new StringBuilder();
        options.append(1).append(",");
        options.append(2).append(",");
        options.append(3).append(",");
        options.append(4).append(",");
        options.append(5).append(",");
        options.append(10).append(",");
        options.append(15).append(",");
        options.append(20).append(",");
        this.setDefault("queue.connections.options", options.toString());
        this.setDefault("queue.download.icon.update", String.valueOf(true));
        this.setDefault("queue.download.icon.threshold", String.valueOf(0x500000L));
        this.setDefault("queue.prompt.sync.action.default", TransferAction.mirror.name());
        this.setDefault("queue.prompt.download.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.prompt.upload.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.prompt.copy.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.prompt.move.action.default", TransferAction.overwrite.name());
        this.setDefault("queue.transcript.open", String.valueOf(false));
        this.setDefault("queue.transcript.size.height", String.valueOf(200));
        this.setDefault("http.compression.enable", String.valueOf(true));
        this.setDefault("http.connections.route", String.valueOf(10));
        this.setDefault("http.connections.reuse", String.valueOf(true));
        this.setDefault("http.connections.total", String.valueOf(Integer.MAX_VALUE));
        this.setDefault("http.connections.retry", String.valueOf(1));
        this.setDefault("http.manager.timeout", String.valueOf(0));
        this.setDefault("http.socket.buffer", String.valueOf(8192));
        this.setDefault("http.credentials.charset", "ISO-8859-1");
        this.setDefault("ftp.datachannel.verify", String.valueOf(false));
        this.setDefault("ftp.socket.buffer", String.valueOf(0));
        this.setDefault("ftp.parser.multiline.strict", String.valueOf(false));
        this.setDefault("ftp.parser.reply.strict", String.valueOf(false));
        this.setDefault("ftp.parser.mlsd.perm.enable", String.valueOf(false));
        this.setDefault("ftp.command.lista", String.valueOf(true));
        this.setDefault("ftp.command.stat", String.valueOf(true));
        this.setDefault("ftp.command.mlsd", String.valueOf(true));
        this.setDefault("ftp.connectmode.fallback", String.valueOf(false));
        this.setDefault("ftp.tls.datachannel", "P");
        this.setDefault("ftp.tls.session.requirereuse", String.valueOf(true));
        this.setDefault("ftp.ssl.session.cache.size", String.valueOf(100));
        this.setDefault("ftp.timezone.auto", String.valueOf(false));
        this.setDefault("ftp.timezone.default", TimeZone.getDefault().getID());
        this.setDefault("ftp.symlink.absolute", String.valueOf(false));
        this.setDefault("s3.signature.version", "AWS4HMACSHA256");
        this.setDefault("s3.location", "us-east-1");
        this.setDefault("s3.bucket.virtualhost.disable", String.valueOf(false));
        this.setDefault("s3.bucket.requesterpays", String.valueOf(true));
        this.setDefault("s3.domain", "amazonaws.com");
        this.setDefault("s3.hostname.default", "s3.amazonaws.com");
        this.setDefault("s3.bucket.acl.default", "private");
        this.setDefault("s3.storage.class", "STANDARD");
        this.setDefault("s3.encryption.algorithm", "");
        this.setDefault("s3.url.expire.seconds", String.valueOf(86400));
        this.setDefault("s3.mfa.serialnumber", "");
        this.setDefault("s3.listing.chunksize", String.valueOf(1000));
        this.setDefault("s3.upload.md5", String.valueOf(true));
        this.setDefault("s3.upload.multipart", String.valueOf(true));
        this.setDefault("s3.upload.multipart.concurrency", String.valueOf(10));
        this.setDefault("s3.upload.multipart.partsize.minimum", String.valueOf(0x500000L));
        this.setDefault("s3.upload.multipart.threshold", String.valueOf(0x6400000L));
        this.setDefault("s3.upload.multipart.required.threshold", String.valueOf(0x140000000L));
        this.setDefault("s3.upload.multipart.size", String.valueOf(0xA00000L));
        this.setDefault("s3.copy.multipart.size", String.valueOf(0x6400000L));
        this.setDefault("s3.upload.expect-continue", String.valueOf(true));
        this.setDefault("s3.download.udt.threshold", String.valueOf(Long.MAX_VALUE));
        this.setDefault("s3.upload.udt.threshold", String.valueOf(Long.MAX_VALUE));
        this.setDefault("s3.accelerate.prompt", String.valueOf(false));
        this.setDefault("s3.logging.prefix", "logs/");
        this.setDefault("google.logging.prefix", "log");
        this.setDefault("cloudfront.logging.prefix", "logs/");
        this.setDefault("onedrive.listing.chunksize", String.valueOf(1000));
        this.setDefault("onedrive.upload.multipart.partsize.minimum", String.valueOf(327680));
        int month = 2592000;
        this.setDefault("s3.cache.seconds", String.valueOf(2592000));
        this.setDefault("s3.metadata.default", "");
        this.setDefault("s3.lifecycle.transition.options", "1 7 10 30 60 180 360 720");
        this.setDefault("s3.lifecycle.delete.options", "1 7 10 30 60 180 360 720");
        this.setDefault("s3.delete.multiple.partition", String.valueOf(1000));
        this.setDefault("azure.metadata.default", "");
        this.setDefault("azure.listing.chunksize", String.valueOf(1000));
        this.setDefault("azure.upload.md5", String.valueOf(false));
        this.setDefault("openstack.authentication.context", "/v2.0/tokens");
        this.setDefault("openstack.upload.metadata.md5", String.valueOf(false));
        this.setDefault("openstack.metadata.default", "");
        this.setDefault("openstack.list.container.limit", String.valueOf(100));
        this.setDefault("openstack.list.object.limit", String.valueOf(10000));
        this.setDefault("openstack.account.preload", String.valueOf(true));
        this.setDefault("openstack.cdn.preload", String.valueOf(true));
        this.setDefault("openstack.container.size.preload", String.valueOf(true));
        this.setDefault("openstack.upload.md5", String.valueOf(true));
        this.setDefault("openstack.upload.largeobject", String.valueOf(true));
        this.setDefault("openstack.upload.largeobject.concurrency", String.valueOf(5));
        this.setDefault("openstack.upload.largeobject.segments.prefix", ".file-segments/");
        this.setDefault("openstack.upload.largeobject.threshold", String.valueOf(0x80000000L));
        this.setDefault("openstack.upload.largeobject.required.threshold", String.valueOf(0x140000000L));
        this.setDefault("openstack.upload.largeobject.size", String.valueOf(1048576000L));
        this.setDefault("openstack.upload.largeobject.size.minimum", String.valueOf(0x100000L));
        this.setDefault("openstack.upload.largeobject.cleanup", String.valueOf(true));
        this.setDefault("openstack.delete.multiple.partition", String.valueOf(10000));
        this.setDefault("googledrive.list.limit", String.valueOf(1000));
        this.setDefault("googledrive.teamdrive.enable", String.valueOf(true));
        this.setDefault("b2.bucket.acl.default", "allPrivate");
        this.setDefault("b2.listing.chunksize", String.valueOf(1000));
        this.setDefault("b2.upload.checksum.verify", String.valueOf(true));
        this.setDefault("b2.upload.largeobject", String.valueOf(true));
        this.setDefault("b2.upload.largeobject.concurrency", String.valueOf(5));
        this.setDefault("b2.upload.largeobject.required.threshold", String.valueOf(0x140000000L));
        this.setDefault("b2.upload.largeobject.threshold", String.valueOf(0xC800000L));
        this.setDefault("b2.upload.largeobject.size", String.valueOf(0x6400000L));
        this.setDefault("b2.upload.largeobject.size.minimum", String.valueOf(0x500000L));
        this.setDefault("b2.metadata.default", "");
        this.setDefault("sds.listing.chunksize", String.valueOf(500));
        this.setDefault("sds.upload.multipart.chunksize", String.valueOf(524288.0));
        this.setDefault("sds.encryption.missingkeys.upload", String.valueOf(true));
        this.setDefault("sds.encryption.missingkeys.scheduler.period", String.valueOf(120000));
        this.setDefault("sds.encryption.keys.ttl", String.valueOf(60000));
        this.setDefault("webdav.ntlm.domain", "");
        this.setDefault("webdav.ntlm.workstation", "");
        this.setDefault("webdav.basic.preemptive", String.valueOf(true));
        this.setDefault("webdav.expect-continue", String.valueOf(true));
        this.setDefault("webdav.redirect.GET.follow", String.valueOf(true));
        this.setDefault("webdav.redirect.HEAD.follow", String.valueOf(true));
        this.setDefault("webdav.redirect.PUT.follow", String.valueOf(false));
        this.setDefault("webdav.redirect.PROPFIND.follow", String.valueOf(true));
        this.setDefault("webdav.upload.md5", String.valueOf(false));
        this.setDefault("webdav.metadata.default", "");
        this.setDefault("analytics.provider.qloudstat.setup", "https://qloudstat.com/configuration/add");
        this.setDefault("analytics.provider.qloudstat.iam.policy", "{\n    \"Statement\": [\n        {\n            \"Action\": [\n                \"s3:GetObject\", \n                \"s3:ListBucket\"\n            ], \n            \"Condition\": {\n                \"Bool\": {\n                    \"aws:SecureTransport\": \"true\"\n                }\n            }, \n            \"Effect\": \"Allow\", \n            \"Resource\": \"arn:aws:s3:::%s/*\"\n        }, \n        {\n            \"Action\": [\n                \"s3:ListAllMyBuckets\", \n                \"s3:GetBucketLogging\", \n                \"s3:GetBucketLocation\"\n            ], \n            \"Effect\": \"Allow\", \n            \"Resource\": \"arn:aws:s3:::*\"\n        }, \n        {\n            \"Action\": [\n                \"cloudfront:GetDistribution\", \n                \"cloudfront:GetDistributionConfig\", \n                \"cloudfront:ListDistributions\", \n                \"cloudfront:GetStreamingDistribution\", \n                \"cloudfront:GetStreamingDistributionConfig\", \n                \"cloudfront:ListStreamingDistributions\"\n            ], \n            \"Condition\": {\n                \"Bool\": {\n                    \"aws:SecureTransport\": \"true\"\n                }\n            }, \n            \"Effect\": \"Allow\", \n            \"Resource\": \"*\"\n        }\n    ]\n}\n");
        this.setDefault("connection.pool.minidle", String.valueOf(1));
        this.setDefault("connection.pool.maxidle", String.valueOf(5));
        this.setDefault("connection.pool.maxtotal", String.valueOf(Integer.MAX_VALUE));
        this.setDefault("connection.login.name", "");
        this.setDefault("connection.login.anon.name", "anonymous");
        this.setDefault("connection.login.anon.pass", "cyberduck@example.net");
        this.setDefault("connection.login.keychain", String.valueOf(true));
        this.setDefault("vault.keychain", String.valueOf(false));
        this.setDefault("connection.port.default", String.valueOf(21));
        this.setDefault("connection.protocol.default", Scheme.ftp.name());
        this.setDefault("connection.socket.keepalive", String.valueOf(true));
        this.setDefault("connection.socket.linger", String.valueOf(false));
        this.setDefault("connection.timeout.seconds", String.valueOf(30));
        this.setDefault("connection.retry", String.valueOf(1));
        this.setDefault("connection.retry.delay", String.valueOf(0));
        this.setDefault("connection.retry.backoff.enable", String.valueOf(false));
        this.setDefault("connection.hostname.default", "");
        this.setDefault("connection.hostname.idn", String.valueOf(true));
        this.setDefault("connection.dns.ipv6", String.valueOf(false));
        this.setDefault("connection.proxy.enable", String.valueOf(true));
        this.setDefault("connection.proxy.ntlm.domain", "");
        this.setDefault("connection.proxy.windows.authentication.enable", String.valueOf(false));
        this.setDefault(String.format("connection.unsecure.warning.%s", new Object[]{Scheme.ftp}), String.valueOf(true));
        this.setDefault(String.format("connection.unsecure.warning.%s", new Object[]{Scheme.http}), String.valueOf(true));
        this.setDefault("connection.ssl.provider.bouncycastle.position", String.valueOf(1));
        this.setDefault("connection.ssl.protocols", "TLSv1.2,TLSv1.1,TLSv1");
        this.setDefault("connection.ssl.cipher.blacklist", "");
        this.setDefault("connection.ssl.x509.revocation.online", String.valueOf(false));
        this.setDefault("connection.ssl.keystore.type", null);
        this.setDefault("connection.ssl.keystore.provider", null);
        this.setDefault("connection.ssl.securerandom.algorithm", "NativePRNG");
        this.setDefault("connection.ssl.securerandom.provider", "SUN");
        this.setDefault("connection.chunksize", String.valueOf(32768));
        this.setDefault("connection.buffer", String.valueOf(8192));
        this.setDefault("connection.buffer.send", String.valueOf(0));
        this.setDefault("connection.buffer.receive", String.valueOf(0));
        this.setDefault("disk.unmount.timeout", String.valueOf(2));
        this.setDefault("bookmark.favicon.download", String.valueOf(true));
        this.setDefault("bookmark.icon.size", String.valueOf(64));
        this.setDefault("bookmark.menu.icon.size", String.valueOf(16));
        this.setDefault("ssh.knownhosts", "~/.ssh/known_hosts");
        this.setDefault("ssh.knownhosts.hostname.hash", String.valueOf(false));
        this.setDefault("ssh.knownhosts.bookmark", "");
        this.setDefault("ssh.authentication.publickey.default.enable", String.valueOf(false));
        this.setDefault("ssh.authentication.publickey.default.rsa", "~/.ssh/id_rsa");
        this.setDefault("ssh.authentication.publickey.default.dsa", "~/.ssh/id_dsa");
        this.setDefault("ssh.authentication.agent.enable", String.valueOf(true));
        this.setDefault("ssh.heartbeat.provider", "keep-alive");
        this.setDefault("ssh.heartbeat.seconds", String.valueOf(60));
        this.setDefault("ssh.compression", "zlib");
        this.setDefault("ssh.algorithm.cipher.blacklist", "");
        this.setDefault("ssh.algorithm.mac.blacklist", "");
        this.setDefault("ssh.algorithm.kex.blacklist", "");
        this.setDefault("ssh.algorithm.signature.blacklist", "");
        this.setDefault("sftp.symlink.absolute", String.valueOf(false));
        this.setDefault("sftp.read.maxunconfirmed", String.valueOf(64));
        this.setDefault("sftp.write.maxunconfirmed", String.valueOf(64));
        this.setDefault("archive.default", "tar.gz");
        this.setDefault("archive.command.create.tar", "cd {2}; tar -cpPf {0}.tar {1}");
        this.setDefault("archive.command.create.tar.gz", "cd {2}; tar -czpPf {0}.tar.gz {1}");
        this.setDefault("archive.command.create.tar.bz2", "cd {2}; tar -cjpPf {0}.tar.bz2 {1}");
        this.setDefault("archive.command.create.zip", "cd {2}; zip -qr {0}.zip {1}");
        this.setDefault("archive.command.create.gz", "gzip -qr {1}");
        this.setDefault("archive.command.create.bz2", "bzip2 -zk {1}");
        this.setDefault("archive.command.expand.tar", "tar -xpPf {0} -C {1}");
        this.setDefault("archive.command.expand.tar.gz", "tar -xzpPf {0} -C {1}");
        this.setDefault("archive.command.expand.tar.bz2", "tar -xjpPf {0} -C {1}");
        this.setDefault("archive.command.expand.zip", "unzip -qn {0} -d {1}");
        this.setDefault("archive.command.expand.gz", "gzip -d {0}");
        this.setDefault("archive.command.expand.bz2", "bzip2 -dk {0}");
        this.setDefault("update.check", String.valueOf(true));
        int day = 86400;
        this.setDefault("update.check.interval", String.valueOf(86400));
        this.setDefault("update.check.timestamp", String.valueOf(0));
        this.setDefault("terminal.bundle.identifier", "com.apple.Terminal");
        this.setDefault("terminal.command", "do script \"{0}\"");
        this.setDefault("terminal.command.ssh", "ssh -t {0} {1}@{2} -p {3} \"cd {4} && exec \\$SHELL\"");
        this.setDefault("network.interface.blacklist", "");
        this.setDefault("threading.pool.size.max", String.valueOf(20));
        this.setDefault("threading.pool.keepalive.seconds", String.valueOf(60L));
        this.setDefault("cryptomator.enable", String.valueOf(true));
        this.setDefault("cryptomator.vault.autodetect", String.valueOf(true));
    }

    protected void setLogging() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        String file = this.getDefault("logging.config");
        URL configuration = null == file ? Preferences.class.getClassLoader().getResource("log4j-default.xml") : Preferences.class.getClassLoader().getResource(file);
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        if (null != configuration) {
            DOMConfigurator.configure((URL)configuration);
        } else {
            root.setLevel(org.apache.log4j.Level.ERROR);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getProperty("logging"))) {
            root.setLevel(org.apache.log4j.Level.toLevel((String)this.getProperty("logging"), (org.apache.log4j.Level)org.apache.log4j.Level.ERROR));
        }
        ImmutableMap map = new ImmutableMap.Builder().put((Object)org.apache.log4j.Level.ALL, (Object)Level.ALL).put((Object)org.apache.log4j.Level.DEBUG, (Object)Level.FINE).put((Object)org.apache.log4j.Level.ERROR, (Object)Level.SEVERE).put((Object)org.apache.log4j.Level.FATAL, (Object)Level.SEVERE).put((Object)org.apache.log4j.Level.INFO, (Object)Level.INFO).put((Object)org.apache.log4j.Level.OFF, (Object)Level.OFF).put((Object)org.apache.log4j.Level.TRACE, (Object)Level.FINEST).put((Object)org.apache.log4j.Level.WARN, (Object)Level.WARNING).build();
        Logger.getLogger("").setLevel((Level)map.get((Object)root.getLevel()));
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)loggers.nextElement();
            if (logger.getLevel() == null) continue;
            Logger.getLogger(logger.getName()).setLevel((Level)map.get((Object)logger.getLevel()));
        }
    }

    public List<String> getList(String property) {
        String value = this.getProperty(property);
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        return Arrays.asList(value.split("(?<!\\\\)\\p{javaWhitespace}+"));
    }

    public Map<String, String> getMap(String property) {
        List<String> list = this.getList(property);
        HashMap<String, String> table = new HashMap<String, String>();
        for (String m : list) {
            if (StringUtils.isBlank((CharSequence)m)) continue;
            if (!m.contains("=")) {
                log.warn((Object)String.format("Invalid header %s", m));
                continue;
            }
            int split = m.indexOf(61);
            String key = m.substring(0, split);
            if (StringUtils.isBlank((CharSequence)key)) {
                log.warn((Object)String.format("Missing key in %s", m));
                continue;
            }
            String value = m.substring(split + 1);
            if (StringUtils.isEmpty((CharSequence)value)) {
                log.warn((Object)String.format("Missing value in %s", m));
                continue;
            }
            table.put(key, value);
        }
        return table;
    }

    public abstract String getProperty(String var1);

    public int getInteger(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return (int)this.getDouble(property);
        }
    }

    public float getFloat(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException e) {
            return (float)this.getDouble(property);
        }
    }

    public long getLong(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1L;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return (long)this.getDouble(property);
        }
    }

    public double getDouble(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return -1.0;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public boolean getBoolean(String property) {
        String v = this.getProperty(property);
        if (null == v) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(true))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(false))) {
            return false;
        }
        if (v.equalsIgnoreCase(String.valueOf(1))) {
            return true;
        }
        if (v.equalsIgnoreCase(String.valueOf(0))) {
            return false;
        }
        return v.equalsIgnoreCase("yes");
    }

    protected void setFactories() {
        this.setDefault("factory.serializer.class", PlistSerializer.class.getName());
        this.setDefault("factory.deserializer.class", PlistDeserializer.class.getName());
        this.setDefault("factory.reader.profile.class", ProfilePlistReader.class.getName());
        this.setDefault("factory.writer.profile.class", PlistWriter.class.getName());
        this.setDefault("factory.reader.transfer.class", TransferPlistReader.class.getName());
        this.setDefault("factory.writer.transfer.class", PlistWriter.class.getName());
        this.setDefault("factory.reader.host.class", HostPlistReader.class.getName());
        this.setDefault("factory.writer.host.class", PlistWriter.class.getName());
        this.setDefault("factory.locale.class", DisabledLocale.class.getName());
        this.setDefault("factory.local.class", Local.class.getName());
        this.setDefault("factory.certificatestore.class", DisabledCertificateStore.class.getName());
        this.setDefault("factory.logincallback.class", DisabledLoginCallback.class.getName());
        this.setDefault("factory.passwordcallback.class", DisabledPasswordCallback.class.getName());
        this.setDefault("factory.alertcallback.class", DisabledAlertCallback.class.getName());
        this.setDefault("factory.hostkeycallback.class", DisabledHostKeyCallback.class.getName());
        this.setDefault("factory.transfererrorcallback.class", DisabledTransferErrorCallback.class.getName());
        this.setDefault("factory.temporaryfiles.class", DefaultTemporaryFileService.class.getName());
        this.setDefault("factory.touch.class", DefaultLocalTouchFeature.class.getName());
        this.setDefault("factory.autorelease.class", DisabledActionOperationBatcher.class.getName());
        this.setDefault("factory.schemehandler.class", DisabledSchemeHandler.class.getName());
        this.setDefault("factory.iconservice.class", DisabledIconService.class.getName());
        this.setDefault("factory.iconcache.class", DisabledIconCache.class.getName());
        this.setDefault("factory.notification.class", DisabledNotificationService.class.getName());
        this.setDefault("factory.sleeppreventer.class", DisabledSleepPreventer.class.getName());
        this.setDefault("factory.quarantine.class", DisabledQuarantineService.class.getName());
        for (Transfer.Type t : Transfer.Type.values()) {
            this.setDefault(String.format("factory.transferpromptcallback.%s.class", t.name()), DisabledTransferPrompt.class.getName());
        }
        this.setDefault("factory.supportdirectoryfinder.class", TemporarySupportDirectoryFinder.class.getName());
        this.setDefault("factory.localsupportdirectoryfinder.class", TemporarySupportDirectoryFinder.class.getName());
        this.setDefault("factory.applicationresourcesfinder.class", TemporaryApplicationResourcesFinder.class.getName());
        this.setDefault("factory.workingdirectory.class", DefaultWorkingDirectoryFinder.class.getName());
        this.setDefault("factory.bookmarkresolver.class", DisabledFilesystemBookmarkResolver.class.getName());
        this.setDefault("factory.watchservice.class", NIOEventWatchService.class.getName());
        this.setDefault("factory.proxy.class", DisabledProxyFinder.class.getName());
        this.setDefault("factory.passwordstore.class", DisabledPasswordStore.class.getName());
        this.setDefault("factory.proxycredentialsstore.class", PreferencesProxyCredentialsStore.class.getName());
        this.setDefault("factory.dateformatter.class", DefaultUserDateFormatter.class.getName());
        this.setDefault("factory.trash.class", NativeLocalTrashFeature.class.getName());
        this.setDefault("factory.symlink.class", NullLocalSymlinkFeature.class.getName());
        this.setDefault("factory.licensefactory.class", DonationKeyFactory.class.getName());
        this.setDefault("factory.badgelabeler.class", DisabledApplicationBadgeLabeler.class.getName());
        this.setDefault("factory.filedescriptor.class", NullFileDescriptor.class.getName());
        this.setDefault("factory.terminalservice.class", DisabledTerminalService.class.getName());
        this.setDefault("factory.applicationfinder.class", DisabledApplicationFinder.class.getName());
        this.setDefault("factory.applicationlauncher.class", DisabledApplicationLauncher.class.getName());
        this.setDefault("factory.browserlauncher.class", DisabledBrowserLauncher.class.getName());
        this.setDefault("factory.reachability.class", DefaultInetAddressReachability.class.getName());
        this.setDefault("factory.updater.class", DisabledPeriodicUpdater.class.getName());
        this.setDefault("factory.threadpool.class", DefaultThreadPool.class.getName());
        this.setDefault("factory.urlfilewriter.class", InternetShortcutFileWriter.class.getName());
        this.setDefault("factory.vault.class", DisabledVault.class.getName());
        this.setDefault("factory.securerandom.class", DefaultSecureRandomProvider.class.getName());
        this.setDefault("factory.providerhelpservice.class", DefaultProviderHelpService.class.getName());
    }

    public abstract void save();

    public abstract void load();

    public String locale() {
        return this.applicationLocales().iterator().next();
    }

    @Override
    public abstract List<String> applicationLocales();

    @Override
    public abstract List<String> systemLocales();

    public String getDisplayName(String locale) {
        Locale l = StringUtils.contains((CharSequence)locale, (CharSequence)"_") ? new Locale(locale.split("_")[0], locale.split("_")[1]) : new Locale(locale);
        return StringUtils.capitalize((String)l.getDisplayName(l));
    }

    private static final class Version {
        private Version() {
        }

        public static String getSpecification() {
            Package pkg = Version.class.getPackage();
            return pkg == null ? null : pkg.getSpecificationVersion();
        }

        public static String getImplementation() {
            Package pkg = Version.class.getPackage();
            return pkg == null ? null : pkg.getImplementationVersion();
        }

        public static void main(String[] args) {
            System.out.println("Version: " + Version.getSpecification());
            System.out.println("Implementation: " + Version.getImplementation());
        }
    }
}

