/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.aquaticprime.LicenseVerifier;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class ReceiptVerifier
implements LicenseVerifier {
    private static final Logger log = Logger.getLogger(ReceiptVerifier.class);
    private final Local file;
    private final String application;
    private final String version;
    private String guid;

    public ReceiptVerifier(Local file) {
        this(file, PreferencesFactory.get().getDefault("application.identifier"), PreferencesFactory.get().getDefault("application.version"));
    }

    public ReceiptVerifier(Local file, String application, String version) {
        this.file = file;
        this.application = application;
        this.version = version;
    }

    @Override
    public boolean verify(LicenseVerifierCallback callback) {
        try {
            NetworkInterface en0;
            CMSSignedData s = new CMSSignedData((InputStream)new FileInputStream(this.file.getAbsolute()));
            Store certs = s.getCertificates();
            SignerInformationStore signers = s.getSignerInfos();
            for (SignerInformation signer : signers.getSigners()) {
                Collection matches = certs.getMatches((Selector)signer.getSID());
                for (X509CertificateHolder holder : matches) {
                    if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)new BouncyCastleProvider()).build(holder))) continue;
                    return false;
                }
            }
            CMSTypedData signedContent = s.getSignedContent();
            byte[] originalContent = (byte[])signedContent.getContent();
            ASN1Primitive asn = ASN1Primitive.fromByteArray((byte[])originalContent);
            byte[] opaque = null;
            String bundleIdentifier = null;
            String bundleVersion = null;
            byte[] hash = null;
            if (asn instanceof ASN1Set) {
                ASN1Set set = (ASN1Set)asn;
                Enumeration enumeration = set.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Encodable value;
                    DLSequence sequence;
                    ASN1Encodable type;
                    Object next = enumeration.nextElement();
                    if (!(next instanceof DLSequence) || !((type = (sequence = (DLSequence)next).getObjectAt(0)) instanceof ASN1Integer)) continue;
                    if (((ASN1Integer)type).getValue().intValue() == 2) {
                        value = sequence.getObjectAt(2);
                        if (!(value instanceof DEROctetString)) continue;
                        bundleIdentifier = new String(((DEROctetString)value).getOctets(), "UTF-8");
                        continue;
                    }
                    if (((ASN1Integer)type).getValue().intValue() == 3) {
                        value = sequence.getObjectAt(2);
                        if (!(value instanceof DEROctetString)) continue;
                        bundleVersion = new String(((DEROctetString)value).getOctets(), "UTF-8");
                        continue;
                    }
                    if (((ASN1Integer)type).getValue().intValue() == 4) {
                        value = sequence.getObjectAt(2);
                        if (!(value instanceof DEROctetString)) continue;
                        opaque = ((DEROctetString)value).getOctets();
                        continue;
                    }
                    if (((ASN1Integer)type).getValue().intValue() != 5 || !((value = sequence.getObjectAt(2)) instanceof DEROctetString)) continue;
                    hash = ((DEROctetString)value).getOctets();
                }
            } else {
                log.error((Object)String.format("Expected set of attributes for %s", asn));
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.application, (CharSequence)StringUtils.trim(bundleIdentifier))) {
                log.error((Object)String.format("Bundle identifier %s in ASN set does not match", bundleIdentifier));
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.version, (CharSequence)StringUtils.trim(bundleVersion))) {
                log.warn((Object)String.format("Bundle version %s in ASN set does not match", bundleVersion));
            }
            if (null == (en0 = NetworkInterface.getByName("en0"))) {
                log.warn((Object)"No network interface en0");
                return true;
            }
            byte[] mac = en0.getHardwareAddress();
            if (null == mac) {
                log.error((Object)"Cannot determine MAC address");
                return true;
            }
            String hex = Hex.encodeHexString((byte[])mac);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Interface en0 %s", hex));
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(mac);
            if (null == opaque) {
                log.error((Object)String.format("Missing opaque string in ASN.1 set %s", asn));
                return false;
            }
            digest.update(opaque);
            if (null == bundleIdentifier) {
                log.error((Object)String.format("Missing bundle identifier in ASN.1 set %s", asn));
                return false;
            }
            digest.update(bundleIdentifier.getBytes(Charset.forName("UTF-8")));
            byte[] result = digest.digest();
            if (Arrays.equals(result, hash)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Valid receipt for GUID %s", hex));
                }
                this.guid = hex;
                return true;
            }
            log.error((Object)String.format("Failed verification. Hash with GUID %s does not match hash in receipt", hex));
            return false;
        }
        catch (IOException | SecurityException | GeneralSecurityException | CMSException e) {
            log.error((Object)"Receipt validation error", e);
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Unknown receipt validation error", (Throwable)e);
            return true;
        }
    }

    public String getGuid() {
        return this.guid;
    }
}

