/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.serializer.Serializer;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PathAttributes
extends Attributes
implements Serializable {
    private static final Logger log = Logger.getLogger(PathAttributes.class);
    public static final PathAttributes EMPTY = new PathAttributes();
    private long size = -1L;
    private long modified = -1L;
    private long accessed = -1L;
    private long created = -1L;
    private String owner;
    private String group;
    private Permission permission = Permission.EMPTY;
    private Acl acl = Acl.EMPTY;
    private Checksum checksum = Checksum.NONE;
    private String etag;
    private String storageClass;
    private Encryption.Algorithm encryption = Encryption.Algorithm.NONE;
    private String versionId;
    private Boolean duplicate;
    private Long revision;
    private String region;
    private String displayname;
    private DescriptiveUrl link;
    private Map<String, String> metadata = Collections.emptyMap();
    private Path vault;
    private Path decrypted;
    private Path encrypted;
    private String directoryId;
    private Map<String, String> custom = Collections.emptyMap();

    public PathAttributes() {
    }

    public PathAttributes(PathAttributes copy) {
        this.size = copy.size;
        this.modified = copy.modified;
        this.accessed = copy.accessed;
        this.created = copy.created;
        this.owner = copy.owner;
        this.group = copy.group;
        this.permission = copy.permission;
        this.acl = copy.acl;
        this.checksum = copy.checksum;
        this.etag = copy.etag;
        this.storageClass = copy.storageClass;
        this.encryption = copy.encryption;
        this.versionId = copy.versionId;
        this.duplicate = copy.duplicate;
        this.revision = copy.revision;
        this.region = copy.region;
        this.displayname = copy.displayname;
        this.link = copy.link;
        this.metadata = copy.metadata;
        this.vault = copy.vault;
        this.decrypted = copy.decrypted;
        this.encrypted = copy.encrypted;
        this.directoryId = copy.directoryId;
    }

    @Override
    public <T> T serialize(Serializer dict) {
        if (this.size != -1L) {
            dict.setStringForKey(String.valueOf(this.size), "Size");
        }
        if (this.modified != -1L) {
            dict.setStringForKey(String.valueOf(this.modified), "Modified");
        }
        if (this.permission != Permission.EMPTY) {
            dict.setObjectForKey(this.permission, "Permission");
        }
        if (this.checksum != Checksum.NONE) {
            dict.setStringForKey(this.checksum.hash, "Checksum");
        }
        if (StringUtils.isNotBlank((CharSequence)this.versionId)) {
            dict.setStringForKey(this.versionId, "Version");
        }
        if (this.duplicate != null) {
            dict.setStringForKey(String.valueOf(this.duplicate), "Duplicate");
        }
        if (StringUtils.isNotBlank((CharSequence)this.region)) {
            dict.setStringForKey(this.region, "Region");
        }
        if (StringUtils.isNotBlank((CharSequence)this.storageClass)) {
            dict.setStringForKey(this.storageClass, "Storage Class");
        }
        if (this.vault != null) {
            if (this.vault.attributes() == this) {
                log.debug((Object)String.format("Skip serializing vault attribute %s to avoid recursion", this.vault));
            } else {
                dict.setObjectForKey(this.vault, "Vault");
            }
        }
        return dict.getSerialized();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getModificationDate() {
        return this.modified;
    }

    public void setModificationDate(long millis) {
        this.modified = millis;
    }

    @Override
    public long getCreationDate() {
        return this.created;
    }

    public void setCreationDate(long millis) {
        this.created = millis;
    }

    @Override
    public long getAccessedDate() {
        return this.accessed;
    }

    public void setAccessedDate(long millis) {
        this.accessed = millis;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission p) {
        this.permission = p;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String o) {
        this.owner = o;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String g) {
        this.group = g;
    }

    @Override
    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public String getETag() {
        return this.etag;
    }

    public void setETag(String etag) {
        this.etag = etag;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public Encryption.Algorithm getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption.Algorithm encryption) {
        this.encryption = encryption;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public PathAttributes withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public PathAttributes withVersionId(VersionId versionId) {
        this.setVersionId(versionId.id);
        return this;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public Path getDecrypted() {
        return this.decrypted;
    }

    public void setDecrypted(Path decrypted) {
        this.decrypted = decrypted;
    }

    public Path getEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(Path encrypted) {
        this.encrypted = encrypted;
    }

    public void setVault(Path vault) {
        this.vault = vault;
    }

    public Path getVault() {
        return this.vault;
    }

    public boolean isDuplicate() {
        return this.duplicate != null && this.duplicate != false;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public DescriptiveUrl getLink() {
        return this.link;
    }

    public void setLink(DescriptiveUrl link) {
        this.link = link;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, String> custom) {
        this.custom = custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathAttributes)) {
            return false;
        }
        PathAttributes that = (PathAttributes)o;
        if (this.modified != that.modified) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.checksum != null ? !this.checksum.equals(that.checksum) : that.checksum != null) {
            return false;
        }
        if (this.etag != null ? !this.etag.equals(that.etag) : that.etag != null) {
            return false;
        }
        if (this.permission != null ? !this.permission.equals(that.permission) : that.permission != null) {
            return false;
        }
        if (this.versionId != null ? !this.versionId.equals(that.versionId) : that.versionId != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        return !(this.region != null ? !this.region.equals(that.region) : that.region != null);
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.modified ^ this.modified >>> 32);
        result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + (this.etag != null ? this.etag.hashCode() : 0);
        result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PathAttributes{");
        sb.append("accessed=").append(this.accessed);
        sb.append(", size=").append(this.size);
        sb.append(", modified=").append(this.modified);
        sb.append(", created=").append(this.created);
        sb.append(", owner='").append(this.owner).append('\'');
        sb.append(", group='").append(this.group).append('\'');
        sb.append(", permission=").append(this.permission);
        sb.append(", acl=").append(this.acl);
        sb.append(", checksum='").append(this.checksum).append('\'');
        sb.append(", etag='").append(this.etag).append('\'');
        sb.append(", storageClass='").append(this.storageClass).append('\'');
        sb.append(", encryption='").append(this.encryption).append('\'');
        sb.append(", versionId='").append(this.versionId).append('\'');
        sb.append(", duplicate=").append(this.duplicate);
        sb.append(", revision=").append(this.revision);
        sb.append(", region='").append(this.region).append('\'');
        sb.append(", metadata=").append(this.metadata);
        sb.append('}');
        return sb.toString();
    }
}

