/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.MimeTypeService;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.Mimetypes;

public class MappingMimeTypeService
implements MimeTypeService {
    private static final Logger log = Logger.getLogger(MappingMimeTypeService.class);
    private static final Mimetypes types = Mimetypes.getInstance();
    private static final String MIME_FILE = "mime.types";

    @Override
    public String getMime(String filename) {
        if (StringUtils.startsWith((CharSequence)filename, (CharSequence)"._")) {
            return "application/octet-stream";
        }
        return types.getMimetype(StringUtils.lowerCase((String)filename));
    }

    static {
        try {
            ClassLoader loader = MappingMimeTypeService.class.getClassLoader();
            Enumeration<URL> resources = loader.getResources(MIME_FILE);
            if (!resources.hasMoreElements()) {
                log.warn((Object)String.format("No file %s in classpath %s", MIME_FILE, loader));
            }
            if (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Loading MIME types from %s", url));
                }
                types.loadAndReplaceMimetypes(url.openStream());
            }
        }
        catch (IOException e) {
            log.error((Object)String.format("Failure loading mime.types. %s", e.getMessage()));
        }
    }
}

