/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.HostnameConfigurator;
import ch.cyberduck.core.HostnameConfiguratorFactory;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.LoginService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.threading.CancelCallback;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LoginConnectionService
implements ConnectionService {
    private static final Logger log = Logger.getLogger(LoginConnectionService.class);
    private final Resolver resolver = new Resolver();
    private final HostKeyCallback key;
    private final ProgressListener listener;
    private final LoginCallback prompt;
    private final ProxyFinder proxy;
    private final LoginService login;

    public LoginConnectionService(LoginCallback prompt, HostKeyCallback key, HostPasswordStore keychain, ProgressListener listener) {
        this(new KeychainLoginService(prompt, keychain), prompt, key, listener);
    }

    public LoginConnectionService(LoginCallback prompt, HostKeyCallback key, HostPasswordStore keychain, ProgressListener listener, ProxyFinder proxy) {
        this(new KeychainLoginService(prompt, keychain), prompt, key, listener, proxy);
    }

    public LoginConnectionService(LoginService login, LoginCallback prompt, HostKeyCallback key, ProgressListener listener) {
        this(login, prompt, key, listener, ProxyFactory.get());
    }

    public LoginConnectionService(LoginService login, LoginCallback prompt, HostKeyCallback key, ProgressListener listener, ProxyFinder proxy) {
        this.login = login;
        this.prompt = prompt;
        this.proxy = proxy;
        this.key = key;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(Session<?> session, Cache<Path> cache, CancelCallback callback) throws BackgroundException {
        Host bookmark = session.getHost();
        if (bookmark.getProtocol().isHostnameConfigurable() && StringUtils.isBlank((CharSequence)bookmark.getHostname())) {
            throw new ConnectionCanceledException();
        }
        if (session.isConnected()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Skip opening connection for session %s", session));
            }
            return false;
        }
        LoginService loginService = this.login;
        synchronized (loginService) {
            this.login.validate(bookmark, MessageFormat.format(LocaleFactory.localizedString("Login {0} with username and password", "Credentials"), BookmarkNameProvider.toString(bookmark)), new LoginOptions(bookmark.getProtocol()));
        }
        this.connect(session, cache, callback);
        return true;
    }

    @Override
    public void close(Session<?> session) {
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Disconnecting {0}", "Status"), session.getHost().getHostname()));
        try {
            session.interrupt();
        }
        catch (BackgroundException e) {
            log.warn((Object)String.format("Ignore failure closing connection %s", e.getMessage()));
        }
    }

    @Override
    public void connect(Session<?> session, Cache<Path> cache, CancelCallback callback) throws BackgroundException {
        if (session.isConnected()) {
            this.close(session);
        }
        Host bookmark = session.getHost();
        HostnameConfigurator configurator = HostnameConfiguratorFactory.get(bookmark.getProtocol());
        String hostname = configurator.getHostname(bookmark.getHostname());
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Resolving {0}", "Status"), hostname));
        Proxy proxy = this.proxy.find(bookmark);
        if (proxy == Proxy.DIRECT) {
            try {
                this.resolver.resolve(hostname, callback);
            }
            catch (ResolveFailedException e) {
                log.warn((Object)String.format("DNS resolver failed for %s", hostname));
                throw e;
            }
        }
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Opening {0} connection to {1}", "Status"), bookmark.getProtocol().getName(), hostname));
        session.open(proxy, this.key, this.prompt);
        this.listener.message(MessageFormat.format(LocaleFactory.localizedString("{0} connection opened", "Status"), bookmark.getProtocol().getName()));
        bookmark.setTimestamp(new Date());
        try {
            this.authenticate(proxy, session, cache, callback);
        }
        catch (BackgroundException e) {
            this.close(session);
            throw e;
        }
    }

    private void authenticate(Proxy proxy, Session session, Cache<Path> cache, CancelCallback callback) throws BackgroundException {
        try {
            this.login.authenticate(proxy, session, cache, this.listener, callback);
        }
        catch (LoginFailureException e) {
            if (session.isConnected()) {
                this.authenticate(proxy, session, cache, callback);
            }
            this.connect(session, cache, callback);
        }
    }
}

