/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.LoginService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.threading.CancelCallback;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KeychainLoginService
implements LoginService {
    private static final Logger log = Logger.getLogger(KeychainLoginService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final LoginCallback callback;
    private final HostPasswordStore keychain;

    public KeychainLoginService(LoginCallback prompt, HostPasswordStore keychain) {
        this.callback = prompt;
        this.keychain = keychain;
    }

    @Override
    public void validate(Host bookmark, String message, LoginOptions options) throws LoginCanceledException {
        Credentials credentials;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validate login credentials for %s", bookmark));
        }
        if ((credentials = bookmark.getCredentials()).isPublicKeyAuthentication() && !credentials.getIdentity().attributes().getPermission().isReadable()) {
            log.warn((Object)String.format("Prompt to select identity file not readable %s", credentials.getIdentity()));
            credentials.setIdentity(this.callback.select(credentials.getIdentity()));
        }
        if (options.keychain) {
            String token;
            String password;
            if (options.password && StringUtils.isBlank((CharSequence)credentials.getPassword()) && StringUtils.isNotBlank((CharSequence)(password = this.keychain.findLoginPassword(bookmark)))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Fetched password from keychain for %s", bookmark));
                }
                credentials.setSaved(false);
                credentials.setPassword(password);
            }
            if (options.token && StringUtils.isBlank((CharSequence)credentials.getToken()) && StringUtils.isNotBlank((CharSequence)(token = this.keychain.findLoginToken(bookmark)))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Fetched token from keychain for %s", bookmark));
                }
                credentials.setSaved(false);
                credentials.setToken(token);
            }
        }
        if (!credentials.validate(bookmark.getProtocol(), options)) {
            if (options.password) {
                StringAppender appender = new StringAppender();
                appender.append(message);
                appender.append(LocaleFactory.localizedString("No login credentials could be found in the Keychain", "Credentials"));
                Credentials prompt = this.callback.prompt(bookmark, credentials.getUsername(), String.format("%s %s", LocaleFactory.localizedString("Login", "Login"), bookmark.getHostname()), appender.toString(), options);
                credentials.setSaved(prompt.isSaved());
                credentials.setUsername(prompt.getUsername());
                credentials.setPassword(prompt.getPassword());
                credentials.setIdentity(prompt.getIdentity());
            }
            if (options.token) {
                Credentials prompt = this.callback.prompt(bookmark, LocaleFactory.localizedString("Provide additional login credentials", "Credentials"), LocaleFactory.localizedString("No login credentials could be found in the Keychain", "Credentials"), options);
                credentials.setSaved(prompt.isSaved());
                credentials.setToken(prompt.getPassword());
            }
        }
    }

    @Override
    public void authenticate(Proxy proxy, Session session, Cache<Path> cache, ProgressListener listener, CancelCallback cancel) throws BackgroundException {
        Host bookmark = session.getHost();
        if (session.alert(this.callback)) {
            this.callback.warn(bookmark, MessageFormat.format(LocaleFactory.localizedString("Unsecured {0} connection", "Credentials"), bookmark.getProtocol().getName()), MessageFormat.format("{0} {1}.", MessageFormat.format(LocaleFactory.localizedString("{0} will be sent in plaintext.", "Credentials"), bookmark.getProtocol().getPasswordPlaceholder()), LocaleFactory.localizedString("Please contact your web hosting service provider for assistance", "Support")), LocaleFactory.localizedString("Continue", "Credentials"), LocaleFactory.localizedString("Disconnect", "Credentials"), String.format("connection.unsecure.%s", bookmark.getHostname()));
        }
        Credentials credentials = bookmark.getCredentials();
        listener.message(MessageFormat.format(LocaleFactory.localizedString("Authenticating as {0}", "Status"), StringUtils.isEmpty((CharSequence)credentials.getUsername()) ? LocaleFactory.localizedString("Unknown") : credentials.getUsername()));
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Attempt authentication for %s", bookmark));
            }
            session.login(proxy, this.keychain, this.callback, cancel);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Login successful for session %s", session));
            }
            listener.message(LocaleFactory.localizedString("Login successful", "Credentials"));
            this.keychain.save(bookmark);
            credentials.setPassed(true);
            credentials.setPassword(null);
        }
        catch (LoginFailureException e) {
            Credentials input;
            listener.message(LocaleFactory.localizedString("Login failed", "Credentials"));
            LoginOptions options = new LoginOptions(bookmark.getProtocol());
            if (options.user && options.password) {
                Credentials input2 = this.callback.prompt(bookmark, credentials.getUsername(), LocaleFactory.localizedString("Login failed", "Credentials"), e.getDetail(), options);
                credentials.setUsername(input2.getUsername());
                credentials.setPassword(input2.getPassword());
                credentials.setSaved(input2.isSaved());
                if (input2.isPublicKeyAuthentication()) {
                    credentials.setIdentity(input2.getIdentity());
                }
                if (input2.isCertificateAuthentication()) {
                    credentials.setCertificate(input2.getCertificate());
                }
            } else if (options.password) {
                Credentials input3 = this.callback.prompt(bookmark, LocaleFactory.localizedString("Login failed", "Credentials"), e.getDetail(), options);
                if (input3.isPasswordAuthentication()) {
                    credentials.setPassword(input3.getPassword());
                    credentials.setSaved(input3.isSaved());
                }
            } else if (options.token && (input = this.callback.prompt(bookmark, LocaleFactory.localizedString("Login failed", "Credentials"), e.getDetail(), options)).isPasswordAuthentication()) {
                credentials.setToken(input.getPassword());
                credentials.setSaved(input.isSaved());
            }
            throw e;
        }
    }
}

