/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.log4j.Logger;

public final class HostParser {
    private static final Logger log = Logger.getLogger(HostParser.class);
    private static final Preferences preferences = PreferencesFactory.get();
    private final Protocol scheme;
    private final ProtocolFactory factory;
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");

    public HostParser() {
        this(ProtocolFactory.get());
    }

    public HostParser(ProtocolFactory factory) {
        this.factory = factory;
        this.scheme = factory.forName(preferences.getProperty("connection.protocol.default"));
    }

    public HostParser(ProtocolFactory factory, Protocol scheme) {
        this.factory = factory;
        this.scheme = scheme;
    }

    public Host get(String url) {
        return HostParser.parse(this.factory, this.scheme, url);
    }

    public static Host parse(String url) {
        return HostParser.parse(ProtocolFactory.get(), ProtocolFactory.get().forName(preferences.getProperty("connection.protocol.default")), url);
    }

    public static Host parse(ProtocolFactory factory, Protocol scheme, String url) {
        String address;
        int cut;
        String input = url.trim();
        int begin = 0;
        Protocol protocol = null;
        if (input.indexOf("://", begin) != -1) {
            cut = input.indexOf("://", begin);
            protocol = factory.forName(input.substring(begin, cut));
            begin += cut - begin + 3;
        }
        if (null == protocol) {
            protocol = scheme;
        }
        String password = null;
        String username = protocol.isAnonymousConfigurable() ? preferences.getProperty("connection.login.anon.name") : preferences.getProperty("connection.login.name");
        if (input.indexOf(64, begin) != -1 && (-1 == input.indexOf(47, begin) || input.indexOf(64, begin) < input.indexOf(47, begin))) {
            cut = input.indexOf(64, begin);
            while (cut < input.lastIndexOf(64) && (input.indexOf(47, begin) == -1 || input.indexOf(64, cut + 1) <= input.indexOf(47, begin))) {
                cut = input.indexOf(64, cut + 1);
            }
            if (input.indexOf(58, begin) != -1 && cut > input.indexOf(58, begin)) {
                username = input.substring(begin, input.indexOf(58, begin));
                cut = input.indexOf(64, begin += username.length() + 1);
                try {
                    username = URLDecoder.decode(username, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                password = input.substring(begin, cut);
                begin += password.length() + 1;
            } else {
                username = input.substring(begin, cut);
                begin += username.length() + 1;
                try {
                    username = URLDecoder.decode(username, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        String hostname = preferences.getProperty("connection.hostname.default");
        String path = null;
        int port = protocol.getDefaultPort();
        if (input.indexOf(91, begin) != -1 && input.indexOf(93, begin) != -1) {
            if (input.indexOf(93, begin) > input.indexOf(91, begin) && HostParser.isv6Address(address = input.substring(begin = input.indexOf(91, begin) + 1, cut = input.indexOf(93, begin)))) {
                hostname = address;
                begin += hostname.length();
            }
        } else if (input.indexOf(47, begin) != -1) {
            cut = input.indexOf(47, begin);
            address = input.substring(begin, cut);
            if (HostParser.isv6Address(address)) {
                hostname = address;
                begin += hostname.length();
            }
        } else if (HostParser.isv6Address(input)) {
            hostname = input;
            begin += hostname.length();
        }
        if (StringUtils.isBlank((CharSequence)hostname) && StringUtils.isNotBlank((CharSequence)input)) {
            cut = input.indexOf(58, begin) != -1 && (input.indexOf(47, begin) == -1 || input.indexOf(58, begin) < input.indexOf(47, begin)) ? input.indexOf(58, begin) : (input.indexOf(47, begin) != -1 ? input.indexOf(47, begin) : input.length());
            hostname = input.substring(begin, cut);
            begin += hostname.length();
        }
        if (input.indexOf(58, begin) != -1 && (input.indexOf(47, begin) == -1 || input.indexOf(58, begin) < input.indexOf(47, begin))) {
            String portString;
            if (input.indexOf(47, begin = input.indexOf(58, begin) + 1) != -1) {
                cut = input.indexOf(47, begin);
                portString = input.substring(begin, cut);
                try {
                    port = Integer.parseInt(portString);
                    begin += portString.length();
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Invalid port number given");
                }
                try {
                    path = URLDecoder.decode(input.substring(begin, input.length()), "UTF-8");
                    begin += path.length();
                }
                catch (UnsupportedEncodingException | IllegalArgumentException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                portString = input.substring(begin, input.length());
                try {
                    port = Integer.parseInt(portString);
                    begin += portString.length();
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Invalid port number given");
                }
            }
        }
        if (input.indexOf(47, begin) != -1) {
            try {
                path = URLDecoder.decode(input.substring(begin, input.length()), "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        switch (protocol.getType()) {
            case b2: 
            case s3: 
            case googlestorage: 
            case swift: 
            case azure: 
            case onedrive: {
                if (!StringUtils.isNotBlank((CharSequence)protocol.getDefaultHostname()) || !StringUtils.isNotBlank((CharSequence)hostname)) break;
                path = StringUtils.isBlank((CharSequence)path) ? PathNormalizer.normalize(hostname) : PathNormalizer.normalize(hostname) + path;
                hostname = protocol.getDefaultHostname();
            }
        }
        if (!protocol.isHostnameConfigurable() && StringUtils.isNotBlank((CharSequence)protocol.getDefaultHostname())) {
            hostname = protocol.getDefaultHostname();
        }
        Host host = new Host(protocol, hostname, port, path, new Credentials(username, password));
        host.configure();
        return host;
    }

    private static boolean isv6Address(String address) {
        if (IPV6_STD_PATTERN.matcher(address).matches()) {
            return true;
        }
        return InetAddressUtils.isIPv6Address((String)address);
    }
}

