/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaSession;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import java.io.IOException;
import java.util.List;

public class MantaDeleteFeature
implements Delete {
    private final MantaSession session;

    public MantaDeleteFeature(MantaSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            callback.delete(file);
            try {
                if (file.isDirectory()) {
                    ((MantaClient)this.session.getClient()).deleteRecursive(file.getAbsolute());
                    continue;
                }
                ((MantaClient)this.session.getClient()).delete(file.getAbsolute());
            }
            catch (MantaException e) {
                throw new MantaExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (MantaClientHttpResponseException e) {
                throw new MantaHttpExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return this.session.isUserWritable(file);
    }

    public boolean isRecursive() {
        return true;
    }
}

