/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.EnumSet;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;

public class SFTPTouchFeature
implements Touch<Void> {
    private final SFTPSession session;

    public SFTPTouchFeature(SFTPSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (file.isFile()) {
            try {
                RemoteFile handle = this.session.sftp().open(file.getAbsolute(), EnumSet.of(OpenMode.CREAT, OpenMode.TRUNC));
                handle.close();
            }
            catch (IOException e) {
                throw new SFTPExceptionMappingService().map("Cannot create file {0}", e, file);
            }
        }
        return file;
    }

    public boolean isSupported(Path workdir) {
        return true;
    }

    public SFTPTouchFeature withWriter(Write writer) {
        return this;
    }
}

