/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.teamlog.ActorLogInfo;
import com.dropbox.core.v2.teamlog.AssetLogInfo;
import com.dropbox.core.v2.teamlog.ContextLogInfo;
import com.dropbox.core.v2.teamlog.EventCategory;
import com.dropbox.core.v2.teamlog.EventDetails;
import com.dropbox.core.v2.teamlog.EventType;
import com.dropbox.core.v2.teamlog.OriginLogInfo;
import com.dropbox.core.v2.teamlog.ParticipantLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TeamEvent {
    protected final Date timestamp;
    protected final EventCategory eventCategory;
    protected final ActorLogInfo actor;
    protected final OriginLogInfo origin;
    protected final boolean involveNonTeamMember;
    protected final ContextLogInfo context;
    protected final List<ParticipantLogInfo> participants;
    protected final List<AssetLogInfo> assets;
    protected final EventType eventType;
    protected final EventDetails details;

    public TeamEvent(Date timestamp, EventCategory eventCategory, ActorLogInfo actor, boolean involveNonTeamMember, ContextLogInfo context, EventType eventType, EventDetails details, OriginLogInfo origin, List<ParticipantLogInfo> participants, List<AssetLogInfo> assets) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Required value for 'timestamp' is null");
        }
        this.timestamp = LangUtil.truncateMillis(timestamp);
        if (eventCategory == null) {
            throw new IllegalArgumentException("Required value for 'eventCategory' is null");
        }
        this.eventCategory = eventCategory;
        if (actor == null) {
            throw new IllegalArgumentException("Required value for 'actor' is null");
        }
        this.actor = actor;
        this.origin = origin;
        this.involveNonTeamMember = involveNonTeamMember;
        if (context == null) {
            throw new IllegalArgumentException("Required value for 'context' is null");
        }
        this.context = context;
        if (participants != null) {
            for (ParticipantLogInfo participantLogInfo : participants) {
                if (participantLogInfo != null) continue;
                throw new IllegalArgumentException("An item in list 'participants' is null");
            }
        }
        this.participants = participants;
        if (assets != null) {
            for (AssetLogInfo assetLogInfo : assets) {
                if (assetLogInfo != null) continue;
                throw new IllegalArgumentException("An item in list 'assets' is null");
            }
        }
        this.assets = assets;
        if (eventType == null) {
            throw new IllegalArgumentException("Required value for 'eventType' is null");
        }
        this.eventType = eventType;
        if (details == null) {
            throw new IllegalArgumentException("Required value for 'details' is null");
        }
        this.details = details;
    }

    public TeamEvent(Date timestamp, EventCategory eventCategory, ActorLogInfo actor, boolean involveNonTeamMember, ContextLogInfo context, EventType eventType, EventDetails details) {
        this(timestamp, eventCategory, actor, involveNonTeamMember, context, eventType, details, null, null, null);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public EventCategory getEventCategory() {
        return this.eventCategory;
    }

    public ActorLogInfo getActor() {
        return this.actor;
    }

    public boolean getInvolveNonTeamMember() {
        return this.involveNonTeamMember;
    }

    public ContextLogInfo getContext() {
        return this.context;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public EventDetails getDetails() {
        return this.details;
    }

    public OriginLogInfo getOrigin() {
        return this.origin;
    }

    public List<ParticipantLogInfo> getParticipants() {
        return this.participants;
    }

    public List<AssetLogInfo> getAssets() {
        return this.assets;
    }

    public static Builder newBuilder(Date timestamp, EventCategory eventCategory, ActorLogInfo actor, boolean involveNonTeamMember, ContextLogInfo context, EventType eventType, EventDetails details) {
        return new Builder(timestamp, eventCategory, actor, involveNonTeamMember, context, eventType, details);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.timestamp, this.eventCategory, this.actor, this.origin, this.involveNonTeamMember, this.context, this.participants, this.assets, this.eventType, this.details});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamEvent other = (TeamEvent)obj;
            return !(this.timestamp != other.timestamp && !this.timestamp.equals(other.timestamp) || this.eventCategory != other.eventCategory && !this.eventCategory.equals((Object)other.eventCategory) || this.actor != other.actor && !this.actor.equals(other.actor) || this.involveNonTeamMember != other.involveNonTeamMember || this.context != other.context && !this.context.equals(other.context) || this.eventType != other.eventType && !this.eventType.equals(other.eventType) || this.details != other.details && !this.details.equals(other.details) || this.origin != other.origin && (this.origin == null || !this.origin.equals(other.origin)) || this.participants != other.participants && (this.participants == null || !this.participants.equals(other.participants)) || this.assets != other.assets && (this.assets == null || !this.assets.equals(other.assets)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamEvent> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamEvent value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("timestamp");
            StoneSerializers.timestamp().serialize(value.timestamp, g);
            g.writeFieldName("event_category");
            EventCategory.Serializer.INSTANCE.serialize(value.eventCategory, g);
            g.writeFieldName("actor");
            ActorLogInfo.Serializer.INSTANCE.serialize(value.actor, g);
            g.writeFieldName("involve_non_team_member");
            StoneSerializers.boolean_().serialize((Boolean)value.involveNonTeamMember, g);
            g.writeFieldName("context");
            ContextLogInfo.Serializer.INSTANCE.serialize(value.context, g);
            g.writeFieldName("event_type");
            EventType.Serializer.INSTANCE.serialize(value.eventType, g);
            g.writeFieldName("details");
            EventDetails.Serializer.INSTANCE.serialize(value.details, g);
            if (value.origin != null) {
                g.writeFieldName("origin");
                StoneSerializers.nullableStruct(OriginLogInfo.Serializer.INSTANCE).serialize(value.origin, g);
            }
            if (value.participants != null) {
                g.writeFieldName("participants");
                StoneSerializers.nullable(StoneSerializers.list(ParticipantLogInfo.Serializer.INSTANCE)).serialize(value.participants, g);
            }
            if (value.assets != null) {
                g.writeFieldName("assets");
                StoneSerializers.nullable(StoneSerializers.list(AssetLogInfo.Serializer.INSTANCE)).serialize(value.assets, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamEvent deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<AssetLogInfo> f_assets;
            List<ParticipantLogInfo> f_participants;
            OriginLogInfo f_origin;
            EventDetails f_details;
            EventType f_eventType;
            ContextLogInfo f_context;
            Boolean f_involveNonTeamMember;
            ActorLogInfo f_actor;
            EventCategory f_eventCategory;
            Date f_timestamp;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_timestamp = null;
                f_eventCategory = null;
                f_actor = null;
                f_involveNonTeamMember = null;
                f_context = null;
                f_eventType = null;
                f_details = null;
                f_origin = null;
                f_participants = null;
                f_assets = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("timestamp".equals(field)) {
                        f_timestamp = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("event_category".equals(field)) {
                        f_eventCategory = EventCategory.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("actor".equals(field)) {
                        f_actor = ActorLogInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("involve_non_team_member".equals(field)) {
                        f_involveNonTeamMember = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("context".equals(field)) {
                        f_context = ContextLogInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("event_type".equals(field)) {
                        f_eventType = EventType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("details".equals(field)) {
                        f_details = EventDetails.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("origin".equals(field)) {
                        f_origin = StoneSerializers.nullableStruct(OriginLogInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("participants".equals(field)) {
                        f_participants = StoneSerializers.nullable(StoneSerializers.list(ParticipantLogInfo.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("assets".equals(field)) {
                        f_assets = StoneSerializers.nullable(StoneSerializers.list(AssetLogInfo.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_timestamp == null) {
                    throw new JsonParseException(p, "Required field \"timestamp\" missing.");
                }
                if (f_eventCategory == null) {
                    throw new JsonParseException(p, "Required field \"event_category\" missing.");
                }
                if (f_actor == null) {
                    throw new JsonParseException(p, "Required field \"actor\" missing.");
                }
                if (f_involveNonTeamMember == null) {
                    throw new JsonParseException(p, "Required field \"involve_non_team_member\" missing.");
                }
                if (f_context == null) {
                    throw new JsonParseException(p, "Required field \"context\" missing.");
                }
                if (f_eventType == null) {
                    throw new JsonParseException(p, "Required field \"event_type\" missing.");
                }
                if (f_details == null) {
                    throw new JsonParseException(p, "Required field \"details\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamEvent value = new TeamEvent(f_timestamp, f_eventCategory, f_actor, f_involveNonTeamMember, f_context, f_eventType, f_details, f_origin, f_participants, f_assets);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final Date timestamp;
        protected final EventCategory eventCategory;
        protected final ActorLogInfo actor;
        protected final boolean involveNonTeamMember;
        protected final ContextLogInfo context;
        protected final EventType eventType;
        protected final EventDetails details;
        protected OriginLogInfo origin;
        protected List<ParticipantLogInfo> participants;
        protected List<AssetLogInfo> assets;

        protected Builder(Date timestamp, EventCategory eventCategory, ActorLogInfo actor, boolean involveNonTeamMember, ContextLogInfo context, EventType eventType, EventDetails details) {
            if (timestamp == null) {
                throw new IllegalArgumentException("Required value for 'timestamp' is null");
            }
            this.timestamp = LangUtil.truncateMillis(timestamp);
            if (eventCategory == null) {
                throw new IllegalArgumentException("Required value for 'eventCategory' is null");
            }
            this.eventCategory = eventCategory;
            if (actor == null) {
                throw new IllegalArgumentException("Required value for 'actor' is null");
            }
            this.actor = actor;
            this.involveNonTeamMember = involveNonTeamMember;
            if (context == null) {
                throw new IllegalArgumentException("Required value for 'context' is null");
            }
            this.context = context;
            if (eventType == null) {
                throw new IllegalArgumentException("Required value for 'eventType' is null");
            }
            this.eventType = eventType;
            if (details == null) {
                throw new IllegalArgumentException("Required value for 'details' is null");
            }
            this.details = details;
            this.origin = null;
            this.participants = null;
            this.assets = null;
        }

        public Builder withOrigin(OriginLogInfo origin) {
            this.origin = origin;
            return this;
        }

        public Builder withParticipants(List<ParticipantLogInfo> participants) {
            if (participants != null) {
                for (ParticipantLogInfo x : participants) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'participants' is null");
                }
            }
            this.participants = participants;
            return this;
        }

        public Builder withAssets(List<AssetLogInfo> assets) {
            if (assets != null) {
                for (AssetLogInfo x : assets) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'assets' is null");
                }
            }
            this.assets = assets;
            return this;
        }

        public TeamEvent build() {
            return new TeamEvent(this.timestamp, this.eventCategory, this.actor, this.involveNonTeamMember, this.context, this.eventType, this.details, this.origin, this.participants, this.assets);
        }
    }
}

