/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class SharedContentViewDetails {
    protected final String sharedContentLink;
    protected final String sharingPermission;
    protected final long targetAssetIndex;

    public SharedContentViewDetails(String sharedContentLink, long targetAssetIndex, String sharingPermission) {
        if (sharedContentLink == null) {
            throw new IllegalArgumentException("Required value for 'sharedContentLink' is null");
        }
        this.sharedContentLink = sharedContentLink;
        this.sharingPermission = sharingPermission;
        this.targetAssetIndex = targetAssetIndex;
    }

    public SharedContentViewDetails(String sharedContentLink, long targetAssetIndex) {
        this(sharedContentLink, targetAssetIndex, null);
    }

    public String getSharedContentLink() {
        return this.sharedContentLink;
    }

    public long getTargetAssetIndex() {
        return this.targetAssetIndex;
    }

    public String getSharingPermission() {
        return this.sharingPermission;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedContentLink, this.sharingPermission, this.targetAssetIndex});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentViewDetails other = (SharedContentViewDetails)obj;
            return (this.sharedContentLink == other.sharedContentLink || this.sharedContentLink.equals(other.sharedContentLink)) && this.targetAssetIndex == other.targetAssetIndex && (this.sharingPermission == other.sharingPermission || this.sharingPermission != null && this.sharingPermission.equals(other.sharingPermission));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedContentViewDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedContentViewDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("shared_content_link");
            StoneSerializers.string().serialize(value.sharedContentLink, g);
            g.writeFieldName("target_asset_index");
            StoneSerializers.uInt64().serialize((Long)value.targetAssetIndex, g);
            if (value.sharingPermission != null) {
                g.writeFieldName("sharing_permission");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sharingPermission, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedContentViewDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_sharingPermission;
            Long f_targetAssetIndex;
            String f_sharedContentLink;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_sharedContentLink = null;
                f_targetAssetIndex = null;
                f_sharingPermission = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("shared_content_link".equals(field)) {
                        f_sharedContentLink = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("target_asset_index".equals(field)) {
                        f_targetAssetIndex = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("sharing_permission".equals(field)) {
                        f_sharingPermission = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_sharedContentLink == null) {
                    throw new JsonParseException(p, "Required field \"shared_content_link\" missing.");
                }
                if (f_targetAssetIndex == null) {
                    throw new JsonParseException(p, "Required field \"target_asset_index\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentViewDetails value = new SharedContentViewDetails(f_sharedContentLink, f_targetAssetIndex, f_sharingPermission);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

