/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class GroupLogInfo {
    protected final String groupId;
    protected final String displayName;
    protected final String externalId;

    public GroupLogInfo(String displayName, String groupId, String externalId) {
        this.groupId = groupId;
        if (displayName == null) {
            throw new IllegalArgumentException("Required value for 'displayName' is null");
        }
        this.displayName = displayName;
        this.externalId = externalId;
    }

    public GroupLogInfo(String displayName) {
        this(displayName, null, null);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public static Builder newBuilder(String displayName) {
        return new Builder(displayName);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupId, this.displayName, this.externalId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupLogInfo other = (GroupLogInfo)obj;
            return (this.displayName == other.displayName || this.displayName.equals(other.displayName)) && (this.groupId == other.groupId || this.groupId != null && this.groupId.equals(other.groupId)) && (this.externalId == other.externalId || this.externalId != null && this.externalId.equals(other.externalId));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("display_name");
            StoneSerializers.string().serialize(value.displayName, g);
            if (value.groupId != null) {
                g.writeFieldName("group_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.groupId, g);
            }
            if (value.externalId != null) {
                g.writeFieldName("external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.externalId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_externalId;
            String f_groupId;
            String f_displayName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_displayName = null;
                f_groupId = null;
                f_externalId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("group_id".equals(field)) {
                        f_groupId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("external_id".equals(field)) {
                        f_externalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_displayName == null) {
                    throw new JsonParseException(p, "Required field \"display_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupLogInfo value = new GroupLogInfo(f_displayName, f_groupId, f_externalId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String displayName;
        protected String groupId;
        protected String externalId;

        protected Builder(String displayName) {
            if (displayName == null) {
                throw new IllegalArgumentException("Required value for 'displayName' is null");
            }
            this.displayName = displayName;
            this.groupId = null;
            this.externalId = null;
        }

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withExternalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public GroupLogInfo build() {
            return new GroupLogInfo(this.displayName, this.groupId, this.externalId);
        }
    }
}

