/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.TimeUnit;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class DurationLogInfo {
    protected final TimeUnit unit;
    protected final long amount;

    public DurationLogInfo(TimeUnit unit, long amount) {
        if (unit == null) {
            throw new IllegalArgumentException("Required value for 'unit' is null");
        }
        this.unit = unit;
        this.amount = amount;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getAmount() {
        return this.amount;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.unit, this.amount});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DurationLogInfo other = (DurationLogInfo)obj;
            return (this.unit == other.unit || this.unit.equals((Object)other.unit)) && this.amount == other.amount;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DurationLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DurationLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("unit");
            TimeUnit.Serializer.INSTANCE.serialize(value.unit, g);
            g.writeFieldName("amount");
            StoneSerializers.uInt64().serialize((Long)value.amount, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public DurationLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_amount;
            TimeUnit f_unit;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_unit = null;
                f_amount = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("unit".equals(field)) {
                        f_unit = TimeUnit.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("amount".equals(field)) {
                        f_amount = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_unit == null) {
                    throw new JsonParseException(p, "Required field \"unit\" missing.");
                }
                if (f_amount == null) {
                    throw new JsonParseException(p, "Required field \"amount\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            DurationLogInfo value = new DurationLogInfo(f_unit, f_amount);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

