/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.auth;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.auth.RateLimitReason;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class RateLimitError {
    protected final RateLimitReason reason;
    protected final long retryAfter;

    public RateLimitError(RateLimitReason reason, long retryAfter) {
        if (reason == null) {
            throw new IllegalArgumentException("Required value for 'reason' is null");
        }
        this.reason = reason;
        this.retryAfter = retryAfter;
    }

    public RateLimitError(RateLimitReason reason) {
        this(reason, 1L);
    }

    public RateLimitReason getReason() {
        return this.reason;
    }

    public long getRetryAfter() {
        return this.retryAfter;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.reason, this.retryAfter});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            RateLimitError other = (RateLimitError)obj;
            return (this.reason == other.reason || this.reason.equals((Object)other.reason)) && this.retryAfter == other.retryAfter;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<RateLimitError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(RateLimitError value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("reason");
            RateLimitReason.Serializer.INSTANCE.serialize(value.reason, g);
            g.writeFieldName("retry_after");
            StoneSerializers.uInt64().serialize((Long)value.retryAfter, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RateLimitError deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_retryAfter;
            RateLimitReason f_reason;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_reason = null;
                f_retryAfter = 1L;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("reason".equals(field)) {
                        f_reason = RateLimitReason.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("retry_after".equals(field)) {
                        f_retryAfter = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_reason == null) {
                    throw new JsonParseException(p, "Required field \"reason\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RateLimitError value = new RateLimitError(f_reason, f_retryAfter);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

