/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Keyboard;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SpatialMatcher
extends BaseMatcher {
    private final Pattern shiftedRx = Pattern.compile("[~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?]");
    private final List<Keyboard> keyboards;

    public SpatialMatcher(List<Keyboard> keyboards) {
        this.keyboards = new ArrayList<Keyboard>(keyboards);
    }

    public SpatialMatcher() {
        this(Keyboard.ALL_KEYBOARDS);
    }

    @Override
    public List<Match> execute(String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Keyboard keyboard : this.keyboards) {
            this.extend(matches, this.spatialMatchHelper(password, keyboard));
        }
        return this.sorted(matches);
    }

    private List<Match> spatialMatchHelper(String password, Keyboard keyboard) {
        ArrayList<Match> matches = new ArrayList<Match>();
        int i = 0;
        while (i < password.length() - 1) {
            int j = i + 1;
            int lastDirection = 0;
            int turns = 0;
            int shiftedCount = keyboard.isSlanted() && this.shiftedRx.matcher(String.valueOf(password.charAt(i))).find() ? 1 : 0;
            Map<Character, List<String>> graph = keyboard.getAdjacencyGraph();
            while (true) {
                List<String> adjacents;
                Character prevChar = Character.valueOf(password.charAt(j - 1));
                boolean found = false;
                int foundDirection = -1;
                int curDirection = -1;
                List<String> list = adjacents = graph.containsKey(prevChar) ? graph.get(prevChar) : Collections.emptyList();
                if (j < password.length()) {
                    Character curChar = Character.valueOf(password.charAt(j));
                    for (String adj : adjacents) {
                        ++curDirection;
                        if (adj == null || !adj.contains(String.valueOf(curChar))) continue;
                        found = true;
                        foundDirection = curDirection;
                        if (adj.indexOf(String.valueOf(curChar)) == 1) {
                            ++shiftedCount;
                        }
                        if (lastDirection == foundDirection) break;
                        ++turns;
                        lastDirection = foundDirection;
                        break;
                    }
                }
                if (!found) break;
                ++j;
            }
            if (j - i > 2) {
                matches.add(MatchFactory.createSpatialMatch(i, j - 1, password.substring(i, j), keyboard.getName(), turns, shiftedCount));
            }
            i = j;
        }
        return matches;
    }
}

