/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.FinderLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class LaunchServicesApplicationFinder
implements ApplicationFinder {
    private static final Logger log = Logger.getLogger(LaunchServicesApplicationFinder.class);
    private static final Map<String, Application> applicationNameCache;
    private static final Map<String, Application> defaultApplicationCache;
    private static final Map<String, List<Application>> defaultApplicationListCache;

    private native String findForType(String var1);

    private native String[] findAllForType(String var1);

    private native boolean register(String var1);

    public List<Application> findAll(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isEmpty((CharSequence)extension)) {
            return Collections.emptyList();
        }
        if (!defaultApplicationListCache.containsKey(extension)) {
            ArrayList<Application> applications = new ArrayList<Application>();
            for (String identifier : this.findAllForType(extension)) {
                applications.add(this.getDescription(identifier));
            }
            Application defaultApplication = this.find(filename);
            if (this.isInstalled(defaultApplication) && !applications.contains(defaultApplication)) {
                applications.add(defaultApplication);
            }
            defaultApplicationListCache.put(extension, applications);
        }
        return defaultApplicationListCache.get(extension);
    }

    public Application find(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if (!defaultApplicationCache.containsKey(extension)) {
            if (StringUtils.isEmpty((CharSequence)extension)) {
                return Application.notfound;
            }
            String path = this.findForType(extension);
            if (StringUtils.isEmpty((CharSequence)path)) {
                defaultApplicationCache.put(extension, Application.notfound);
            } else {
                NSBundle bundle = NSBundle.bundleWithPath((String)path);
                if (null == bundle) {
                    log.error((Object)String.format("Loading bundle %s failed", path));
                    defaultApplicationCache.put(extension, Application.notfound);
                } else {
                    defaultApplicationCache.put(extension, this.getDescription(bundle.bundleIdentifier()));
                }
            }
        }
        return defaultApplicationCache.get(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getDescription(String search) {
        if (applicationNameCache.containsKey(search)) {
            return applicationNameCache.get(search);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find application for %s", search));
        }
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            String name;
            String identifier;
            String path;
            NSWorkspace workspace = NSWorkspace.sharedWorkspace();
            if (null != workspace.absolutePathForAppBundleWithIdentifier(search)) {
                path = workspace.absolutePathForAppBundleWithIdentifier(search);
            } else {
                log.warn((Object)String.format("Cannot determine installation path for bundle identifier %s. Try with name.", search));
                path = workspace.fullPathForApplication(search);
            }
            if (StringUtils.isNotBlank((CharSequence)path)) {
                NSBundle app = NSBundle.bundleWithPath((String)path);
                if (null == app) {
                    log.error((Object)String.format("Loading bundle %s failed", path));
                    identifier = search;
                    name = FilenameUtils.removeExtension((String)new FinderLocal(path).getDisplayName());
                } else {
                    NSDictionary dict = app.infoDictionary();
                    if (null == dict) {
                        log.error((Object)String.format("Loading application dictionary for bundle %s failed", path));
                        applicationNameCache.put(search, Application.notfound);
                        // ** MonitorExit[var4_2] (shouldn't be in output)
                        return null;
                    }
                    NSObject bundlename = dict.objectForKey("CFBundleName");
                    if (null == bundlename) {
                        log.warn((Object)String.format("No CFBundleName in bundle %s", path));
                        name = FilenameUtils.removeExtension((String)new FinderLocal(path).getDisplayName());
                    } else {
                        name = bundlename.toString();
                    }
                    NSObject bundleIdentifier = dict.objectForKey("CFBundleIdentifier");
                    if (null == bundleIdentifier) {
                        log.warn((Object)String.format("No CFBundleName in bundle %s", path));
                        identifier = search;
                    } else {
                        identifier = bundleIdentifier.toString();
                    }
                }
            } else {
                log.warn((Object)String.format("Cannot determine installation path for %s", search));
                applicationNameCache.put(search, Application.notfound);
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return Application.notfound;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            Application application = new Application(identifier, name);
            applicationNameCache.put(search, application);
            return application;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstalled(Application application) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            if (Application.notfound.equals((Object)application)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(application.getIdentifier()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(Local application) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            if (!application.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.register(application.getAbsolute());
        }
    }

    static {
        Native.load((String)"core");
        applicationNameCache = Collections.synchronizedMap(new LRUMap(20));
        defaultApplicationCache = Collections.synchronizedMap(new LRUMap(20));
        defaultApplicationListCache = Collections.synchronizedMap(new LRUMap(20));
    }
}

