/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.log4j.Logger;

public class S3MoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(S3MoveFeature.class);
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final S3AccessControlListFeature accessControlListFeature;
    private Delete delete;

    public S3MoveFeature(S3Session session) {
        this(session, new S3AccessControlListFeature(session));
    }

    public S3MoveFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
        this.delete = new S3DefaultDeleteFeature(session);
    }

    public Path move(Path source, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path copy = new S3ThresholdCopyFeature(this.session, this.accessControlListFeature).copy(source, renamed, status.length(source.attributes().getSize()), connectionCallback);
        this.delete.delete(Collections.singletonList(source), (PasswordCallback)connectionCallback, callback);
        return copy;
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

