/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.auth;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.log4j.Logger;

public class AWSCredentialsConfigurator
implements CredentialsConfigurator {
    private static final Logger log = Logger.getLogger(AWSCredentialsConfigurator.class);
    private final AWSCredentialsProvider[] providers;

    public AWSCredentialsConfigurator(AWSCredentialsProvider ... providers) {
        this.providers = providers;
    }

    public Credentials configure(Host host) {
        Credentials credentials = host.getCredentials();
        if (host.getHostname().endsWith(PreferencesFactory.get().getProperty("s3.hostname.default")) && !credentials.validate(host.getProtocol(), new LoginOptions(host.getProtocol()).password(false))) {
            for (AWSCredentialsProvider provider : this.providers) {
                try {
                    AWSCredentials c = provider.getCredentials();
                    credentials.setUsername(c.getAWSAccessKeyId());
                    credentials.setPassword(c.getAWSSecretKey());
                    break;
                }
                catch (SdkClientException e) {
                    log.debug((Object)String.format("Ignore failure loading credentials from provider %s", provider));
                }
            }
        }
        return credentials;
    }

    public void reload() {
        for (AWSCredentialsProvider provider : this.providers) {
            provider.refresh();
        }
    }
}

