/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.CommandLinePathParser;
import ch.cyberduck.cli.CommandLineUriParser;
import ch.cyberduck.cli.Console;
import ch.cyberduck.cli.DeletePathFinder;
import ch.cyberduck.cli.DisabledTerminalPromptReader;
import ch.cyberduck.cli.DownloadGlobFilter;
import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.LinuxTerminalPreferences;
import ch.cyberduck.cli.SingleTransferItemFinder;
import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.cli.TerminalActionFinder;
import ch.cyberduck.cli.TerminalBackgroundAction;
import ch.cyberduck.cli.TerminalCertificateStore;
import ch.cyberduck.cli.TerminalController;
import ch.cyberduck.cli.TerminalHelpPrinter;
import ch.cyberduck.cli.TerminalHostKeyVerifier;
import ch.cyberduck.cli.TerminalListProgressListener;
import ch.cyberduck.cli.TerminalLoginCallback;
import ch.cyberduck.cli.TerminalLoginService;
import ch.cyberduck.cli.TerminalOptionsBuilder;
import ch.cyberduck.cli.TerminalOptionsInputValidator;
import ch.cyberduck.cli.TerminalPasswordCallback;
import ch.cyberduck.cli.TerminalPreferences;
import ch.cyberduck.cli.TerminalProgressListener;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.cli.TerminalStreamListener;
import ch.cyberduck.cli.TerminalTranscriptListener;
import ch.cyberduck.cli.TerminalTransferBackgroundAction;
import ch.cyberduck.cli.TerminalTransferFactory;
import ch.cyberduck.cli.TerminalTransferPrompt;
import ch.cyberduck.cli.TerminalVersionPrinter;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.DisabledTranscriptListener;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginConnectionService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.TildePathExpander;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.azure.AzureProtocol;
import ch.cyberduck.core.b2.B2Protocol;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.dropbox.DropboxProtocol;
import ch.cyberduck.core.editor.DefaultEditorListener;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.googledrive.DriveProtocol;
import ch.cyberduck.core.googlestorage.GoogleStorageProtocol;
import ch.cyberduck.core.hubic.HubicProtocol;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.irods.IRODSProtocol;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.manta.MantaProtocol;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.onedrive.OneDriveProtocol;
import ch.cyberduck.core.openstack.SwiftProtocol;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.sds.SDSProtocol;
import ch.cyberduck.core.sftp.SFTPProtocol;
import ch.cyberduck.core.spectra.SpectraProtocol;
import ch.cyberduck.core.ssl.CertificateStoreX509TrustManager;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.PreferencesX509KeyManager;
import ch.cyberduck.core.threading.DisconnectBackgroundAction;
import ch.cyberduck.core.threading.SessionBackgroundAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.transfer.CopyTransfer;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.vault.VaultRegistryFactory;
import ch.cyberduck.core.worker.CreateDirectoryWorker;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.cyberduck.core.worker.SessionListWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.fs.FilesystemFactory;
import ch.cyberduck.fs.FilesystemWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class Terminal {
    private static final Logger log = Logger.getLogger(Terminal.class);
    private final Preferences preferences;
    private final TerminalController controller;
    private final TerminalPromptReader reader;
    private final Cache<Path> cache;
    private final ProgressListener progress;
    private final TranscriptListener transcript;
    private final CommandLine input;
    private final Options options;

    public Terminal(TerminalPreferences defaults, Options options, CommandLine input) {
        this.preferences = defaults.withDefaults(input);
        ProtocolFactory.get().register(new Protocol[]{new FTPProtocol(), new FTPTLSProtocol(), new SFTPProtocol(), new DAVProtocol(), new DAVSSLProtocol(), new SwiftProtocol(), new S3Protocol(), new GoogleStorageProtocol(), new AzureProtocol(), new IRODSProtocol(), new SpectraProtocol(), new B2Protocol(), new DriveProtocol(), new HubicProtocol(), new DropboxProtocol(), new DropboxProtocol(), new OneDriveProtocol(), new LocalProtocol(), new SDSProtocol(), new MantaProtocol()});
        this.options = options;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Parsed options %s from input %s", options, input));
        }
        this.input = input;
        this.cache = new PathCache(this.preferences.getInteger("browser.cache.size"));
        this.progress = input.hasOption(TerminalOptionsBuilder.Params.quiet.name()) ? new DisabledListProgressListener() : new TerminalProgressListener();
        this.transcript = input.hasOption(TerminalOptionsBuilder.Params.verbose.name()) ? new TerminalTranscriptListener() : new DisabledTranscriptListener();
        this.reader = input.hasOption(TerminalOptionsBuilder.Params.assumeyes.name()) ? new DisabledTerminalPromptReader() : new InteractiveTerminalPromptReader();
        this.controller = new TerminalController(this.progress, this.transcript);
    }

    public static void main(String ... args) {
        Terminal.open(args, new LinuxTerminalPreferences());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void open(String[] args, TerminalPreferences defaults) {
        PreferencesFactory.set(defaults);
        Options options = TerminalOptionsBuilder.options();
        Console console = new Console();
        try {
            PosixParser parser = new PosixParser();
            CommandLine input = parser.parse(options, args);
            Terminal terminal = new Terminal(defaults, options, input);
            switch (terminal.execute()) {
                case success: {
                    console.printf("%s%n", "");
                    System.exit(0);
                }
                case failure: {
                    console.printf("%s%n", "");
                    System.exit(1);
                    return;
                }
            }
            return;
        }
        catch (ParseException e) {
            console.printf("%s%n", e.getMessage());
            console.printf("Try '%s' for more options.%n", "duck --help");
            System.exit(1);
            return;
        }
        catch (FactoryException e) {
            console.printf("%s%n", e.getMessage());
            System.exit(1);
            return;
        }
        catch (Throwable error) {
            error.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        finally {
            TemporaryFileServiceFactory.get().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exit execute() {
        final Console console = new Console();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                console.printf("Uncaught failure with error message %s. Quitting application\u2026", e.getMessage());
                System.exit(1);
            }
        });
        if (this.input.hasOption(TerminalAction.help.name())) {
            TerminalHelpPrinter.print(this.options);
            return Exit.success;
        }
        if (this.input.hasOption(TerminalAction.version.name())) {
            TerminalVersionPrinter.print(this.preferences);
            return Exit.success;
        }
        if (!new TerminalOptionsInputValidator().validate(this.input)) {
            console.printf("Try '%s' for more options.%n", "duck --help");
            return Exit.failure;
        }
        this.configure(this.input);
        SessionPool source = SessionPool.DISCONNECTED;
        SessionPool destination = SessionPool.DISCONNECTED;
        try {
            Path remote;
            Object home;
            TerminalAction action = TerminalActionFinder.get(this.input);
            if (null == action) {
                Exit exit = Exit.failure;
                return exit;
            }
            Object uri = this.input.getOptionValue(action.name());
            Host host = new CommandLineUriParser(this.input).parse((String)uri);
            LoginConnectionService connect = new LoginConnectionService(new TerminalLoginService(this.input, new TerminalLoginCallback(this.reader)), new TerminalLoginCallback(this.reader), (HostKeyCallback)((Object)new TerminalHostKeyVerifier(this.reader)), this.progress);
            source = SessionPoolFactory.create(connect, this.transcript, this.cache, host, new CertificateStoreX509TrustManager(new DefaultTrustManagerHostnameCallback(host), new TerminalCertificateStore(this.reader)), new PreferencesX509KeyManager(host, new TerminalCertificateStore(this.reader)), VaultRegistryFactory.create(new TerminalPasswordCallback()), new SessionPoolFactory.Usage[0]);
            if (new CommandLinePathParser(this.input).parse((String)uri).getAbsolute().startsWith(TildePathExpander.PREFIX)) {
                home = source.getFeature(Home.class);
                remote = new TildePathExpander(home.find()).expand(new CommandLinePathParser(this.input).parse((String)uri));
            } else {
                remote = new CommandLinePathParser(this.input).parse((String)uri);
            }
            switch (action) {
                case edit: {
                    home = this.edit(source, remote);
                    return home;
                }
                case list: 
                case longlist: {
                    home = this.list(source, remote, this.input.hasOption(TerminalOptionsBuilder.Params.longlist.name()));
                    return home;
                }
                case mount: {
                    home = this.mount(source);
                    return home;
                }
                case delete: {
                    home = this.delete(source, remote);
                    return home;
                }
                case mkdir: {
                    home = this.mkdir(source, remote, this.input.getOptionValue(TerminalOptionsBuilder.Params.region.name()));
                    return home;
                }
            }
            switch (action) {
                case download: 
                case upload: 
                case synchronize: {
                    home = this.transfer(new TerminalTransferFactory().create(this.input, host, remote, new ArrayList<TransferItem>(new SingleTransferItemFinder().find(this.input, action, remote))), source, SessionPool.DISCONNECTED);
                    return home;
                }
                case copy: {
                    Host target = new CommandLineUriParser(this.input).parse(this.input.getOptionValues(action.name())[1]);
                    destination = SessionPoolFactory.create(connect, this.transcript, this.cache, target, new CertificateStoreX509TrustManager(new DefaultTrustManagerHostnameCallback(target), new TerminalCertificateStore(this.reader)), new PreferencesX509KeyManager(target, new TerminalCertificateStore(this.reader)), VaultRegistryFactory.create(new TerminalPasswordCallback()), new SessionPoolFactory.Usage[0]);
                    Exit exit = this.transfer(new CopyTransfer(host, target, Collections.singletonMap(remote, new CommandLinePathParser(this.input).parse(this.input.getOptionValues(action.name())[1]))), source, destination);
                    return exit;
                }
            }
            try {
                throw new BackgroundException(LocaleFactory.localizedString("Unknown"), String.format("Unknown transfer type %s", action.name()));
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)"Connection canceled", (Throwable)e);
                uri = Exit.success;
                return uri;
            }
            catch (BackgroundException e) {
                StringAppender b = new StringAppender();
                b.append(e.getMessage());
                b.append(e.getDetail());
                console.printf("%n%s", b.toString());
            }
        }
        finally {
            this.disconnect(source);
            this.disconnect(destination);
        }
        return Exit.failure;
    }

    protected void configure(CommandLine input) {
        boolean preserve = input.hasOption(TerminalOptionsBuilder.Params.preserve.name());
        this.preferences.setProperty("queue.upload.permissions.change", preserve);
        this.preferences.setProperty("queue.upload.timestamp.change", preserve);
        this.preferences.setProperty("queue.download.permissions.change", preserve);
        this.preferences.setProperty("queue.download.timestamp.change", preserve);
        boolean retry = input.hasOption(TerminalOptionsBuilder.Params.retry.name());
        if (retry) {
            if (StringUtils.isNotBlank((CharSequence)input.getOptionValue(TerminalOptionsBuilder.Params.retry.name()))) {
                this.preferences.setProperty("connection.retry", NumberUtils.toInt((String)input.getOptionValue(TerminalOptionsBuilder.Params.retry.name()), (int)1));
            } else {
                this.preferences.setProperty("connection.retry", 1);
            }
        } else {
            this.preferences.setProperty("connection.retry", 0);
        }
        boolean udt = input.hasOption(TerminalOptionsBuilder.Params.udt.name());
        if (udt) {
            this.preferences.setProperty("s3.download.udt.threshold", 0L);
            this.preferences.setProperty("s3.upload.udt.threshold", 0L);
        }
        if (input.hasOption(TerminalOptionsBuilder.Params.parallel.name())) {
            this.preferences.setProperty("queue.connections.limit", NumberUtils.toInt((String)input.getOptionValue(TerminalOptionsBuilder.Params.parallel.name()), (int)2));
        }
        this.preferences.setProperty("connection.login.keychain", !input.hasOption(TerminalOptionsBuilder.Params.nokeychain.name()));
    }

    protected Exit transfer(Transfer transfer, SessionPool source, SessionPool destination) {
        TransferSpeedometer meter = new TransferSpeedometer(transfer);
        Host host = transfer.getSource();
        if (this.input.hasOption(TerminalOptionsBuilder.Params.parallel.name())) {
            host.setTransfer(Host.TransferType.concurrent);
        } else {
            host.setTransfer(Host.TransferType.newconnection);
        }
        TransferPrompt prompt = this.input.hasOption(TerminalOptionsBuilder.Params.existing.name()) ? new DisabledTransferPrompt(){

            @Override
            public TransferAction prompt(TransferItem file) {
                return TransferAction.forName(Terminal.this.input.getOptionValue(TerminalOptionsBuilder.Params.existing.name()));
            }
        } : (this.input.hasOption(TerminalOptionsBuilder.Params.quiet.name()) ? new DisabledTransferPrompt(){

            @Override
            public TransferAction prompt(TransferItem file) {
                return TransferAction.comparison;
            }
        } : new TerminalTransferPrompt(transfer.getType()));
        TerminalTransferBackgroundAction action = new TerminalTransferBackgroundAction(this.controller, this.reader, source, destination, transfer, new TransferOptions().reload(true), prompt, meter, this.input.hasOption(TerminalOptionsBuilder.Params.quiet.name()) ? new DisabledStreamListener() : new TerminalStreamListener(meter));
        if (!this.execute(action)) {
            return Exit.failure;
        }
        return Exit.success;
    }

    protected Exit mount(SessionPool session) {
        WorkerBackgroundAction<Path> action = new WorkerBackgroundAction<Path>(this.controller, session, new FilesystemWorker(FilesystemFactory.get(this.controller, session.getHost(), this.cache)));
        if (!this.execute(action)) {
            return Exit.failure;
        }
        return Exit.success;
    }

    protected Exit list(SessionPool session, Path remote, boolean verbose) {
        SessionListWorker worker = new SessionListWorker(this.cache, remote, new TerminalListProgressListener(this.reader, verbose));
        TerminalBackgroundAction<AttributedList<Path>> action = new TerminalBackgroundAction<AttributedList<Path>>(this.controller, session, worker);
        if (!this.execute(action)) {
            return Exit.failure;
        }
        return Exit.success;
    }

    protected Exit delete(SessionPool session, Path remote) throws BackgroundException {
        ArrayList<Path> files = new ArrayList<Path>();
        for (TransferItem i : new DeletePathFinder().find(this.input, TerminalAction.delete, remote)) {
            files.add(i.remote);
        }
        DeleteWorker worker = StringUtils.containsAny((CharSequence)remote.getName(), (char[])new char[]{'*'}) ? new DeleteWorker(new TerminalLoginCallback(this.reader), files, this.cache, new DownloadGlobFilter(remote.getName()), this.progress) : new DeleteWorker(new TerminalLoginCallback(this.reader), files, this.cache, this.progress);
        TerminalBackgroundAction<List<Path>> action = new TerminalBackgroundAction<List<Path>>(this.controller, session, worker);
        if (!this.execute(action)) {
            return Exit.failure;
        }
        return Exit.success;
    }

    protected Exit mkdir(SessionPool session, Path remote, String region) throws BackgroundException {
        CreateDirectoryWorker worker = new CreateDirectoryWorker(remote, region);
        TerminalBackgroundAction<Path> action = new TerminalBackgroundAction<Path>(this.controller, session, worker);
        if (!this.execute(action)) {
            return Exit.failure;
        }
        return Exit.success;
    }

    protected Exit edit(SessionPool session, Path remote) throws BackgroundException {
        CountDownLatch lock;
        Application application;
        EditorFactory factory = EditorFactory.instance();
        ApplicationFinder finder = ApplicationFinderFactory.get();
        if (StringUtils.isNotBlank((CharSequence)this.input.getOptionValue(TerminalOptionsBuilder.Params.application.name()))) {
            application = finder.getDescription(this.input.getOptionValue(TerminalOptionsBuilder.Params.application.name()));
            if (!finder.isInstalled(application)) {
                throw new BackgroundException(LocaleFactory.localizedString("Unknown"), String.format("Application %s not found", this.input.getOptionValue(TerminalOptionsBuilder.Params.application.name())));
            }
        } else {
            application = factory.getEditor(remote.getName());
        }
        if (!finder.isInstalled(application)) {
            throw new BackgroundException(LocaleFactory.localizedString("Unknown"), String.format("No application found to edit %s", remote.getName()));
        }
        Editor editor = factory.create(this.controller, session, application, remote);
        Worker<Transfer> worker = editor.open(new ApplicationQuitCallback(lock = new CountDownLatch(1)){
            final /* synthetic */ CountDownLatch val$lock;
            {
                this.val$lock = countDownLatch;
            }

            @Override
            public void callback() {
                this.val$lock.countDown();
            }
        }, new DisabledTransferErrorCallback(), new DefaultEditorListener(this.controller, session, editor));
        TerminalBackgroundAction<Transfer> action = new TerminalBackgroundAction<Transfer>(this.controller, session, worker);
        if (!this.execute(action)) {
            return Exit.failure;
        }
        try {
            lock.await();
        }
        catch (InterruptedException e) {
            return Exit.failure;
        }
        return Exit.success;
    }

    protected void disconnect(SessionPool session) {
        if (session == SessionPool.DISCONNECTED) {
            return;
        }
        this.execute(new DisconnectBackgroundAction(this.controller, session){

            @Override
            public void message(String message) {
            }
        });
    }

    protected <T> boolean execute(SessionBackgroundAction<T> action) {
        try {
            this.controller.background(action).get();
            return !action.hasFailed();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    private static enum Exit {
        success,
        failure;

    }
}

