/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import java.io.IOException;

public class MantaDirectoryFeature
implements Directory {
    private final MantaSession session;

    public MantaDirectoryFeature(MantaSession session) {
        this.session = session;
    }

    public Path mkdir(Path directory, String region, TransferStatus status) throws BackgroundException {
        try {
            ((MantaClient)this.session.getClient()).putDirectory(directory.getAbsolute());
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map("Cannot create folder {0}", e, directory);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map("Cannot create folder {0}", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, directory);
        }
        return directory;
    }

    public boolean isSupported(Path workdir, String name) {
        return this.session.isUserWritable(workdir);
    }

    public Directory withWriter(Write writer) {
        return this;
    }
}

